/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.functionality.index.action;

import eu.dnetlib.data.provision.index.rmi.IndexServiceException;
import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.functionality.index.feed.FeedMode;
import eu.dnetlib.functionality.index.utils.MetadataReference;
import eu.dnetlib.functionality.index.utils.ServiceTools;
import org.apache.commons.codec.binary.Base64;
import org.springframework.beans.factory.annotation.Autowired;

public class AbstractIndexAction {
    @Autowired
    protected ServiceTools serviceTools;

    public String getServiceAddress(String backendId) {
        return this.serviceTools.getServiceAddress(backendId);
    }

    protected String getMDFormatFields(MetadataReference mdRef) {
        return this.serviceTools.getIndexFields(mdRef);
    }

    protected String getEpr(BlackboardJob job) {
        return new String(Base64.decodeBase64((byte[])((String)job.getParameters().get("resultset_epr")).getBytes()));
    }

    protected String getIndexDSId(BlackboardJob job) {
        return (String)job.getParameters().get("id");
    }

    protected FeedMode getFeedMode(BlackboardJob job) {
        return FeedMode.valueOf((String)job.getParameters().get("feeding_type"));
    }

    protected MetadataReference getMetadataReference(String indexDSId) throws IndexServiceException {
        return this.serviceTools.getMetadataRef(indexDSId);
    }

    protected MetadataReference getMetadataReference(BlackboardJob job) {
        String format = (String)job.getParameters().get("format");
        String layout = (String)job.getParameters().get("layout");
        String interpretation = (String)job.getParameters().get("interpretation");
        return new MetadataReference(format, layout, interpretation);
    }

    protected String getBackend(BlackboardJob job) {
        return (String)job.getParameters().get("backend_Id");
    }

    protected String getQuery(BlackboardJob job) {
        return (String)job.getParameters().get("query");
    }
}

