package eu.dnetlib.functionality.index.action;

import org.apache.commons.codec.binary.Base64;
import org.springframework.beans.factory.annotation.Autowired;

import eu.dnetlib.data.provision.index.rmi.IndexServiceException;
import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.functionality.index.feed.FeedMode;
import eu.dnetlib.functionality.index.utils.MetadataReference;
import eu.dnetlib.functionality.index.utils.ServiceTools;

/**
 * The Class AbstractIndexAction.
 */
public class AbstractIndexAction {

	/** The serivce tools. */
	@Autowired
	protected ServiceTools serviceTools;

	/**
	 * Gets the service address.
	 *
	 * @return the service address
	 */
	public String getServiceAddress(final String backendId) {
		return serviceTools.getServiceAddress(backendId);
	}

	/**
	 * Gets the service address.
	 *
	 * @return the service address
	 */
	// public String getServiceAddress() {
	// return serviceTools.getServiceAddress();
	// }

	/**
	 * Gets the MD format fields.
	 *
	 * @param mdRef
	 *            the md ref
	 * @return the MD format fields
	 */
	protected String getMDFormatFields(final MetadataReference mdRef) {
		return serviceTools.getIndexFields(mdRef);
	}

	/**
	 * Gets the epr.
	 *
	 * @param job
	 *            the job
	 * @return the epr
	 */
	protected String getEpr(final BlackboardJob job) {
		return new String(Base64.decodeBase64(job.getParameters().get(BBParam.RS_EPR).getBytes()));
	}

	/**
	 * Gets the index ds id.
	 *
	 * @param job
	 *            the job
	 * @return the index ds id
	 */
	protected String getIndexDSId(final BlackboardJob job) {
		return job.getParameters().get(BBParam.INDEX_DS_ID);
	}

	/**
	 * Gets the feed mode.
	 *
	 * @param job
	 *            the job
	 * @return the feed mode
	 */
	protected FeedMode getFeedMode(final BlackboardJob job) {
		return FeedMode.valueOf(job.getParameters().get(BBParam.FEEDING_TYPE));
	}

	/**
	 * Gets the metadata reference.
	 *
	 * @param indexDSId
	 *            the index ds id
	 * @return the metadata reference
	 * @throws IndexServiceException
	 *             the index service exception
	 */
	protected MetadataReference getMetadataReference(final String indexDSId) throws IndexServiceException {
		return serviceTools.getMetadataRef(indexDSId);
	}

	protected MetadataReference getMetadataReference(final BlackboardJob job) {

		final String format = job.getParameters().get(BBParam.FORMAT);
		final String layout = job.getParameters().get(BBParam.LAYOUT);
		final String interpretation = job.getParameters().get(BBParam.INTERP);

		return new MetadataReference(format, layout, interpretation);
	}

	/**
	 * Gets the backend.
	 *
	 * @param job
	 *            the job
	 * @return the backend
	 */
	protected String getBackend(final BlackboardJob job) {
		return job.getParameters().get(BBParam.BACKEND);
	}

	/**
	 * Gets the query.
	 *
	 * @param job
	 *            the job
	 * @return the query
	 */
	protected String getQuery(final BlackboardJob job) {
		return job.getParameters().get(BBParam.QUERY);
	}

}
