/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.functionality.index.feed;

import eu.dnetlib.functionality.index.IndexCollection;
import eu.dnetlib.functionality.index.feed.FeedResult;
import eu.dnetlib.functionality.index.model.document.IndexDocument;
import java.util.concurrent.Callable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DocumentFeeder
implements Callable<FeedResult> {
    private static final Log log = LogFactory.getLog(DocumentFeeder.class);
    private IndexCollection indexCollection;
    private Iterable<IndexDocument> records;

    public DocumentFeeder(IndexCollection indexCollection, Iterable<IndexDocument> records) {
        this.indexCollection = indexCollection;
        this.records = records;
    }

    @Override
    public FeedResult call() throws Exception {
        FeedResult res = new FeedResult(System.currentTimeMillis());
        block5: for (IndexDocument doc : this.records) {
            switch (doc.getStatus()) {
                case OK: {
                    boolean rsp = this.indexCollection.add(doc);
                    if (rsp) {
                        res.add();
                        continue block5;
                    }
                    res.mark();
                    continue block5;
                }
                case MARKED: {
                    res.mark();
                    log.debug((Object)("skipping record: " + doc.getFieldValue("__indexrecordidentifier")));
                    continue block5;
                }
                case ERROR: {
                    res.skip();
                    log.info((Object)("Error on record: " + doc.getFieldValue("__indexrecordidentifier")));
                    continue block5;
                }
            }
            throw new IllegalStateException("unknow document status");
        }
        return res;
    }
}

