/*
 *
 */
package eu.dnetlib.functionality.index;

import java.util.Map;

import eu.dnetlib.functionality.cql.CqlValueTransformerMap;
import org.dom4j.Document;

import eu.dnetlib.data.provision.index.rmi.IndexServiceException;
import eu.dnetlib.functionality.index.feed.DocumentMapperFactory;
import eu.dnetlib.functionality.index.model.Any.ValueType;
import eu.dnetlib.functionality.index.query.IndexQueryFactory;
import eu.dnetlib.functionality.index.utils.MetadataReference;

/**
 * The Interface IndexServerDAO.
 */
public interface IndexServerDAO extends IndexBackendDescriptor {

	/**
	 * Creates the index collection.
	 * 
	 * @param mdref
	 *            the mdref
	 * @param fields
	 *            the fields
	 * @return the index collection
	 * @throws IndexServiceException
	 *             the index service exception
	 */
	public void createIndexCollection(final MetadataReference mdref, final String fields) throws IndexServiceException;

	/**
	 * Update index collection.
	 * 
	 * @param mdRef
	 *            the md ref
	 * @param fields
	 *            the fields
	 * @throws IndexServiceException
	 *             the index service exception
	 */
	public void updateIndexCollection(final MetadataReference mdRef, final Document fields) throws IndexServiceException;

	/**
	 * Gets the index collection.
	 * 
	 * @param mdRef
	 *            the md ref
	 * @return the index collection
	 * @throws IndexServiceException
	 *             the index service exception
	 */
	public IndexCollection getIndexCollection(final MetadataReference mdRef) throws IndexServiceException;

	/**
	 * Gets the schema.
	 * 
	 * @param mdRef
	 *            the md ref
	 * @return the schema
	 * @throws IndexServiceException
	 *             the index service exception
	 */
	public Map<String, ValueType> getSchema(final MetadataReference mdRef) throws IndexServiceException;;

	/**
	 * Gets the cql value transformer map.
	 * 
	 * @param mdRef
	 *            the md ref
	 * @return the cql value transformer map
	 * @throws IndexServiceException
	 *             the index service exception
	 */
	public CqlValueTransformerMap getCqlValueTransformerMap(final MetadataReference mdRef) throws IndexServiceException;

	/**
	 * Gets the document mapper factory.
	 * 
	 * @return the document mapper factory
	 * @throws IndexServiceException
	 *             the index service exception
	 */
	public DocumentMapperFactory getDocumentMapperFactory() throws IndexServiceException;

	/**
	 * Gets the index query factory.
	 * 
	 * @return the index query factory
	 */
	public IndexQueryFactory getIndexQueryFactory();

	/**
	 * Shutdown the index server.
	 * 
	 * @param mdRef
	 *            the md ref
	 * @throws IndexServiceException
	 *             the index service exception
	 */
	public void shutdown(final MetadataReference mdRef) throws IndexServiceException;

}
