package eu.dnetlib.functionality.index.actors;

import javax.annotation.Resource;

import akka.actor.ActorSystem;
import akka.actor.TypedActor;
import akka.actor.TypedProps;
import akka.japi.Creator;
import eu.dnetlib.functionality.cql.CqlTranslator;
import eu.dnetlib.functionality.index.IndexServerDAOMap;
import eu.dnetlib.functionality.index.utils.ServiceTools;
import eu.dnetlib.miscutils.factory.Factory;
import org.springframework.beans.factory.annotation.Required;

// TODO springify actor parameter with a prototype bean
/**
 * A factory for creating IndexFeedActor objects.
 */
public class IndexFeedActorFactory implements Factory<IndexFeedActor> {

	/** The index server dao map. */
	private IndexServerDAOMap indexServerDAOMap;

	/** The service tools. */
	private ServiceTools serviceTools;

	/** The actor system. */
	private ActorSystem actorSystem;
	
	/** CqlTranslator. */
	@Resource
	private CqlTranslator translator;

	/**
	 * {@inheritDoc}
	 *
	 * @see eu.dnetlib.miscutils.factory.Factory#newInstance()
	 */
	@Override
	public IndexFeedActor newInstance() {
		return TypedActor.get(getActorSystem()).typedActorOf(new TypedProps<IndexFeedActorImpl>(IndexFeedActor.class, new Creator<IndexFeedActorImpl>() {

			@Override
			public IndexFeedActorImpl create() throws Exception {
				return new IndexFeedActorImpl(getIndexServerDAOMap(), getServiceTools(), translator);
			}
		}));
	}

	/**
	 * Sets the service tools.
	 *
	 * @param serviceTools
	 *            the new service tools
	 */
	@Required
	public void setServiceTools(final ServiceTools serviceTools) {
		this.serviceTools = serviceTools;
	}

	/**
	 * Gets the service tools.
	 *
	 * @return the service tools
	 */
	public ServiceTools getServiceTools() {
		return serviceTools;
	}

	/**
	 * Gets the actor system.
	 *
	 * @return the actor system
	 */
	public ActorSystem getActorSystem() {
		return actorSystem;
	}

	/**
	 * Sets the actor system.
	 *
	 * @param actorSystem
	 *            the new actor system
	 */
	@Required
	public void setActorSystem(final ActorSystem actorSystem) {
		this.actorSystem = actorSystem;
	}

	/**
	 * Gets the index server dao map.
	 *
	 * @return the indexServerDAOMap
	 */
	public IndexServerDAOMap getIndexServerDAOMap() {
		return indexServerDAOMap;
	}

	/**
	 * Sets the index server dao map.
	 *
	 * @param indexServerDAOMap
	 *            the indexServerDAOMap to set
	 */
	@Required
	public void setIndexServerDAOMap(final IndexServerDAOMap indexServerDAOMap) {
		this.indexServerDAOMap = indexServerDAOMap;
	}

}
