/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.functionality.index;

import com.google.common.collect.Maps;
import eu.dnetlib.functionality.index.IndexBackendDescriptor;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.ListableBeanFactory;

public class IndexBackendEnumerator
implements BeanFactoryAware {
    private ListableBeanFactory beanFactory;

    public Map<String, IndexBackendDescriptor> getAll() {
        return this.beanFactory.getBeansOfType(IndexBackendDescriptor.class);
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = (ListableBeanFactory)beanFactory;
    }

    public ListableBeanFactory getBeanFactory() {
        return this.beanFactory;
    }

    public Map<String, String> getAllProtocols() {
        HashMap res = Maps.newHashMap();
        for (IndexBackendDescriptor desc : this.getAll().values()) {
            String id = desc.getEndpoint().get("id");
            String address = desc.getEndpoint().get("address");
            res.put(id, address);
        }
        return res;
    }

    public Map<String, String> getAllServiceProperties() {
        HashMap res = Maps.newHashMap();
        for (IndexBackendDescriptor desc : this.getAll().values()) {
            String name = desc.getEndpoint().get("id");
            if (name == null) {
                throw new IllegalStateException("Missing field name");
            }
            Map<String, String> currentProp = desc.getServiceProperties();
            for (String key : currentProp.keySet()) {
                res.put(name + ":" + key, currentProp.get(key));
            }
        }
        return res;
    }

    public <T extends IndexBackendDescriptor> T getDescriptor(String identifier) {
        for (IndexBackendDescriptor desc : this.getAll().values()) {
            String name = desc.getEndpoint().get("id");
            if (!name.equals(identifier)) continue;
            return (T)desc;
        }
        return null;
    }
}

