/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.functionality.index;

import eu.dnetlib.enabling.actions.AbstractSubscriptionAction;
import eu.dnetlib.functionality.index.IndexServerDAO;
import eu.dnetlib.functionality.index.IndexServerDAOMap;
import eu.dnetlib.functionality.index.utils.MetadataReference;
import eu.dnetlib.functionality.index.utils.MetadataReferenceFactory;
import eu.dnetlib.functionality.index.utils.ServiceTools;
import eu.dnetlib.miscutils.dom4j.XPathHelper;
import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;

public class MdFormatNotificationHandler
extends AbstractSubscriptionAction {
    private static final Log log = LogFactory.getLog(MdFormatNotificationHandler.class);
    @Autowired
    private IndexServerDAOMap indexServerDAOMap;
    @Autowired
    private ServiceTools serviceTools;
    private Executor executor = Executors.newSingleThreadExecutor();
    private final transient ThreadLocal<SAXReader> domFactory = new ThreadLocal<SAXReader>(){

        @Override
        protected SAXReader initialValue() {
            return new SAXReader();
        }
    };
    private boolean enabled;

    public void notified(String subscrId, String topic, String rsId, final String profile) {
        if (!topic.startsWith(this.getTopicPrefix()) || !this.isEnabled()) {
            return;
        }
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    Document doc = MdFormatNotificationHandler.this.parse(profile);
                    Node formatNode = doc.selectSingleNode("//CONFIGURATION/NAME/text()");
                    if (formatNode != null && !formatNode.asXML().isEmpty()) {
                        String format = formatNode.asXML();
                        Iterable layouts = XPathHelper.selectElements((Node)doc, (String)"//STATUS/LAYOUTS/LAYOUT");
                        Node interpretationNode = doc.selectSingleNode("//CONFIGURATION/INTERPRETATION/text()");
                        String interpretation = interpretationNode.asXML();
                        log.info((Object)("found a change in mdFormat: " + format));
                        for (Element element : layouts) {
                            String layout = element.attributeValue("name");
                            log.info((Object)String.format("processing format '%s', layout '%s', interpretation '%s'", format, layout, interpretation));
                            MetadataReference mdRef = MetadataReferenceFactory.getMetadata((String)format, (String)layout, (String)interpretation);
                            log.info((Object)("got metadata reference " + mdRef.toString()));
                            Document fields = MdFormatNotificationHandler.this.parse(element.selectSingleNode("./FIELDS").asXML());
                            log.debug((Object)("fields " + fields.asXML()));
                            List backends = MdFormatNotificationHandler.this.serviceTools.getBackendIds(mdRef);
                            if (backends == null || backends.isEmpty()) {
                                log.warn((Object)("There is no backendId in profiles for mdref " + mdRef));
                            }
                            log.info((Object)("found backends " + backends.toString()));
                            for (String backendId : backends) {
                                log.info((Object)("processing backend " + backendId));
                                IndexServerDAO idxDao = MdFormatNotificationHandler.this.indexServerDAOMap.getIndexServerDAO(backendId);
                                if (idxDao == null) {
                                    log.error((Object)("No index found for the mdformat " + mdRef));
                                    throw new RuntimeException("No index found for the mdformat " + mdRef);
                                }
                                log.info((Object)String.format("Found index DAO which serve %s, backendId %s", mdRef.toString(), backendId));
                                idxDao.updateIndexCollection(mdRef, fields);
                            }
                        }
                    }
                    log.info((Object)"Upload schema completed");
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    @Required
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    private Document parse(String source) throws DocumentException {
        return this.domFactory.get().read((Reader)new StringReader(source));
    }

    public boolean isEnabled() {
        return this.enabled;
    }
}

