/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.functionality.index.action;

import eu.dnetlib.data.provision.index.rmi.IndexServiceException;
import eu.dnetlib.enabling.resultset.client.IterableResultSetClient;
import eu.dnetlib.enabling.resultset.client.ResultSetClientFactory;
import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.enabling.tools.blackboard.BlackboardServerAction;
import eu.dnetlib.enabling.tools.blackboard.BlackboardServerHandler;
import eu.dnetlib.functionality.index.action.AbstractIndexAction;
import eu.dnetlib.functionality.index.action.IndexAction;
import eu.dnetlib.functionality.index.actors.ActorMap;
import eu.dnetlib.functionality.index.actors.BlackboardActorCallback;
import eu.dnetlib.functionality.index.actors.IndexFeedActorFactory;
import eu.dnetlib.functionality.index.actors.ResultsetKeepAliveCallback;
import eu.dnetlib.functionality.index.feed.FeedMode;
import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SimpleTrigger;
import org.quartz.Trigger;
import org.quartz.TriggerKey;
import org.quartz.impl.triggers.SimpleTriggerImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;

public class FeedIndexAction
extends AbstractIndexAction
implements BlackboardServerAction<IndexAction> {
    private static final Log log = LogFactory.getLog(FeedIndexAction.class);
    @Autowired
    private ActorMap actorMap;
    @Autowired
    private IndexFeedActorFactory feedActorFactory;
    @Autowired
    private transient ResultSetClientFactory resultSetClientFactory;
    private Scheduler jobScheduler;
    private transient JobDetail rsKeepaliveJob;
    private long repeatDelay;

    public void execute(BlackboardServerHandler handler, BlackboardJob job) throws Exception {
        handler.ongoing(job);
        log.info((Object)"FEED job set to ONGOING");
        JobKey jobKey = new JobKey("resultsetKeepaliveJob");
        JobDetail tmp = this.getJobScheduler().getJobDetail(jobKey);
        String epr = this.getEpr(job);
        String triggerId = UUID.randomUUID().toString();
        String dsId = this.getIndexDSId(job);
        FeedMode feedMode = this.getFeedMode(job);
        String backendId = this.getBackend(job);
        boolean emptyResult = this.getEmptyResult(job);
        if (backendId == null) {
            throw new IndexServiceException("No backend identifier information in CREATE message");
        }
        if (tmp == null) {
            log.fatal((Object)"re-registering job detail");
            this.getJobScheduler().addJob(this.getRsKeepaliveJob(), true);
        }
        log.debug((Object)("\n\n scheduling resultSet keepalive trigger: " + triggerId + "\n\n"));
        this.getJobScheduler().scheduleJob((Trigger)this.getResultsetTrigger(epr, triggerId));
        if (!this.actorMap.hasActor(backendId)) {
            this.actorMap.addActor(backendId, this.feedActorFactory.newInstance());
        }
        IterableResultSetClient rsClient = this.resultSetClientFactory.getClient(epr);
        this.actorMap.getActor(backendId).feedIndex(dsId, feedMode, (Iterable<String>)rsClient, this.newRSKeepAliveCallback(triggerId), this.newBBActorCallback(handler, job), backendId, emptyResult);
    }

    private boolean getEmptyResult(BlackboardJob job) {
        if (job.getParameters().containsKey("emptyResult")) {
            String emptyResult = ((String)job.getParameters().get("emptyResult")).toLowerCase().trim();
            return "true".equals(emptyResult);
        }
        return false;
    }

    private SimpleTrigger getResultsetTrigger(String rsEpr, String triggerId) {
        SimpleTriggerImpl trigger = new SimpleTriggerImpl(triggerId, "keepalive", -1, this.getRepeatDelay());
        trigger.getJobDataMap().put("resultset_epr", rsEpr);
        trigger.setJobName("resultsetKeepaliveJob");
        trigger.setJobGroup("keepalive");
        return trigger;
    }

    private BlackboardActorCallback newBBActorCallback(final BlackboardServerHandler handler, final BlackboardJob job) {
        return new BlackboardActorCallback(){

            @Override
            public void setJobDone() {
                log.info((Object)(job.getAction() + " job set to DONE"));
                handler.done(job);
            }

            @Override
            public void setJobFailed(Throwable exception) {
                log.error((Object)(job.getAction() + " job set to FAILED "), exception);
                handler.failed(job, exception);
            }
        };
    }

    private ResultsetKeepAliveCallback newRSKeepAliveCallback(final String triggerId) {
        return new ResultsetKeepAliveCallback(){

            @Override
            public void unschedule() {
                try {
                    log.info((Object)("\n\n unscheduling resultSet keepalive trigger: " + triggerId + "\n\n"));
                    TriggerKey triggerKey = new TriggerKey(triggerId);
                    FeedIndexAction.this.jobScheduler.unscheduleJob(triggerKey);
                }
                catch (SchedulerException e) {
                    log.warn((Object)("cannot unschedule RSKeepAlive triggerId: " + triggerId));
                    throw new RuntimeException(e);
                }
            }
        };
    }

    public JobDetail getRsKeepaliveJob() {
        return this.rsKeepaliveJob;
    }

    @Required
    public void setRsKeepaliveJob(JobDetail rsKeepaliveJob) {
        this.rsKeepaliveJob = rsKeepaliveJob;
    }

    public Scheduler getJobScheduler() {
        return this.jobScheduler;
    }

    @Required
    public void setJobScheduler(Scheduler jobScheduler) {
        this.jobScheduler = jobScheduler;
    }

    public long getRepeatDelay() {
        return this.repeatDelay;
    }

    @Required
    public void setRepeatDelay(long repeatDelay) {
        this.repeatDelay = repeatDelay;
    }
}

