/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.functionality.index.utils;

import eu.dnetlib.miscutils.functional.UnaryFunction;
import org.apache.oro.text.perl.Perl5Util;

public class HighlightUtils
implements UnaryFunction<String, String> {
    public static final String DEFAULT_HL_PRE = "[hl]";
    public static final String DEFAULT_HL_POST = "[/hl]";
    private static String CLEAN_HEADER = "s#\\[/?hl\\]##gm";
    private static String CLEAN_REGEX_OPEN = "<([^>]*)\\[hl\\]([^>]*)>";
    private static String CLEAN_REGEX_CLOSE = "<([^>]*)\\[\\/hl\\]([^>]*)>";
    private Perl5Util p5util = new Perl5Util();

    public String evaluate(String doc) {
        String[] chunk = doc.split("</header>");
        String string = this.cleanHeader(chunk[0]) + "</header>" + this.cleanBody(chunk[1]);
        return string;
    }

    private String cleanHeader(String header) {
        return this.p5util.substitute(CLEAN_HEADER, header);
    }

    private String cleanBody(String body) {
        String res = body.replaceAll(CLEAN_REGEX_OPEN, "<$1$2>").replaceAll(CLEAN_REGEX_CLOSE, "<$1$2>");
        if (res.equals(body)) {
            return res;
        }
        return this.cleanBody(res);
    }
}

