/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.functionality.modular.ui.index;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import eu.dnetlib.data.provision.index.rmi.IndexServiceException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.functionality.index.client.IndexClient;
import eu.dnetlib.functionality.index.client.IndexClientException;
import eu.dnetlib.functionality.index.client.response.BrowseEntry;
import eu.dnetlib.functionality.index.client.response.LookupResponse;
import eu.dnetlib.functionality.index.client.solr.SolrIndexClientFactory;
import eu.dnetlib.functionality.modular.ui.AbstractAjaxController;
import eu.dnetlib.functionality.modular.ui.index.IndexClientMap;
import eu.dnetlib.functionality.modular.ui.index.models.IndexInfo;
import eu.dnetlib.functionality.modular.ui.index.models.MdFormatInfo;
import eu.dnetlib.miscutils.functional.xml.ApplyXslt;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.ClassPathResource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class IndexServiceInternalController
extends AbstractAjaxController {
    private static final Log log = LogFactory.getLog(IndexServiceInternalController.class);
    @Resource
    private UniqueServiceLocator serviceLocator;
    @Autowired
    private SolrIndexClientFactory indexClientFactory;
    @Autowired
    private IndexClientMap clientMap;

    @RequestMapping(value={"/ui/index/indexMetadataFormats.do"})
    @ResponseBody
    public List<MdFormatInfo> indexMetadataFormats(ModelMap map) throws Exception {
        String xquery = "for $x in //RESOURCE_PROFILE[.//RESOURCE_TYPE/@value='MDFormatDSResourceType'] let $format:= $x//CONFIGURATION/NAME/string()  for $y in $x//LAYOUTS/LAYOUT  let $layout:= $y/@name/string() let $interpretation:= $x//CONFIGURATION/INTERPRETATION/text() let $id:=$x//RESOURCE_IDENTIFIER/@value/string()  return concat($format,'-',$layout,'-',$interpretation,'::', $id) ";
        log.debug((Object)"Executing lookup queryfor $x in //RESOURCE_PROFILE[.//RESOURCE_TYPE/@value='MDFormatDSResourceType'] let $format:= $x//CONFIGURATION/NAME/string()  for $y in $x//LAYOUTS/LAYOUT  let $layout:= $y/@name/string() let $interpretation:= $x//CONFIGURATION/INTERPRETATION/text() let $id:=$x//RESOURCE_IDENTIFIER/@value/string()  return concat($format,'-',$layout,'-',$interpretation,'::', $id) ");
        return this.quickSearchProfile("for $x in //RESOURCE_PROFILE[.//RESOURCE_TYPE/@value='MDFormatDSResourceType'] let $format:= $x//CONFIGURATION/NAME/string()  for $y in $x//LAYOUTS/LAYOUT  let $layout:= $y/@name/string() let $interpretation:= $x//CONFIGURATION/INTERPRETATION/text() let $id:=$x//RESOURCE_IDENTIFIER/@value/string()  return concat($format,'-',$layout,'-',$interpretation,'::', $id) ").stream().map(MdFormatInfo::initFromXqueryResult).collect(Collectors.toList());
    }

    @RequestMapping(value={"/ui/index/indexDatastructures.do"})
    @ResponseBody
    public List<IndexInfo> indexDatastructures(@RequestParam(value="backend", required=true) String backend) throws Exception {
        String xquery = "for $x in //RESOURCE_PROFILE[.//RESOURCE_TYPE/@value='IndexDSResourceType' and .//BACKEND/@ID='%s'] let $format := $x//METADATA_FORMAT let $layout := $x//METADATA_FORMAT_LAYOUT let $interpretation :=$x//METADATA_FORMAT_INTERPRETATION let $id :=$x//RESOURCE_IDENTIFIER/@value let $backendid := $x//BACKEND/@ID let $size := $x//INDEX_SIZE return concat($format, ':-:',$layout,':-:',$interpretation,':-:',$id,':-:',$backendid,':-:',$size)";
        log.debug((Object)("Executing lookup query" + String.format("for $x in //RESOURCE_PROFILE[.//RESOURCE_TYPE/@value='IndexDSResourceType' and .//BACKEND/@ID='%s'] let $format := $x//METADATA_FORMAT let $layout := $x//METADATA_FORMAT_LAYOUT let $interpretation :=$x//METADATA_FORMAT_INTERPRETATION let $id :=$x//RESOURCE_IDENTIFIER/@value let $backendid := $x//BACKEND/@ID let $size := $x//INDEX_SIZE return concat($format, ':-:',$layout,':-:',$interpretation,':-:',$id,':-:',$backendid,':-:',$size)", backend)));
        return this.quickSearchProfile(String.format("for $x in //RESOURCE_PROFILE[.//RESOURCE_TYPE/@value='IndexDSResourceType' and .//BACKEND/@ID='%s'] let $format := $x//METADATA_FORMAT let $layout := $x//METADATA_FORMAT_LAYOUT let $interpretation :=$x//METADATA_FORMAT_INTERPRETATION let $id :=$x//RESOURCE_IDENTIFIER/@value let $backendid := $x//BACKEND/@ID let $size := $x//INDEX_SIZE return concat($format, ':-:',$layout,':-:',$interpretation,':-:',$id,':-:',$backendid,':-:',$size)", backend)).stream().map(IndexInfo::newInstanceFromString).collect(Collectors.toList());
    }

    @RequestMapping(value={"/ui/index/mdFormatInfo.do"})
    @ResponseBody
    public List<String> mdFormatInfo(@RequestParam(value="id", required=true) String id, @RequestParam(value="layout", required=true) String layout) throws Exception {
        String xqueryTemplate = "//RESOURCE_PROFILE[.//RESOURCE_IDENTIFIER/@value='%s']//LAYOUT[./@name/string()='%s'] //FIELD[./@tokenizable/string()='false' or ./@type = 'int' or ./@type = 'date']/@name/string()";
        log.debug((Object)("executing query: " + String.format(xqueryTemplate, id, layout)));
        return this.quickSearchProfile(String.format(xqueryTemplate, id, layout));
    }

    @RequestMapping(value={"/ui/index/backend.do"})
    @ResponseBody
    public Set<String> getBackendAvailable() throws Exception {
        String xquery = "for $x in //RESOURCE_PROFILE[.//RESOURCE_TYPE/@value='IndexDSResourceType'] return distinct-values($x//BACKEND/@ID/string())";
        log.debug((Object)("executing query: " + xquery));
        return Sets.newHashSet(this.quickSearchProfile(xquery));
    }

    @RequestMapping(value={"/ui/index/browse.do"}, method={RequestMethod.POST})
    @ResponseBody
    public List<BrowseEntry> browse(ModelMap map, @RequestParam(value="backend", required=true) String backend, @RequestParam(value="format", required=true) String format, @RequestParam(value="layout", required=true) String layout, @RequestParam(value="interpretation", required=true) String interpretation, @RequestParam(value="fields", required=true) String fields, @RequestParam(value="query", required=true) String query) throws IndexClientException {
        List browseFields = (List)new Gson().fromJson(fields, new TypeToken<List<String>>(){}.getType());
        if (browseFields != null) {
            for (String s : browseFields) {
                log.debug((Object)("Browse field " + s));
            }
        }
        String indexClientKeys = format + "-" + layout + "-" + interpretation;
        IndexClient client = null;
        if (this.clientMap.getMap().containsKey(indexClientKeys)) {
            client = this.clientMap.getMap().get(indexClientKeys);
        } else {
            client = this.indexClientFactory.getClient(format, layout, interpretation);
            this.clientMap.getMap().put(indexClientKeys, client);
        }
        List result = client.browse(query, browseFields, 99);
        return result;
    }

    @RequestMapping(value={"/ui/index/delete.do"}, method={RequestMethod.POST})
    @ResponseBody
    public long delete(ModelMap map, @RequestParam(value="backend", required=true) String backend, @RequestParam(value="format", required=true) String format, @RequestParam(value="layout", required=true) String layout, @RequestParam(value="interpretation", required=true) String interpretation, @RequestParam(value="query", required=true) String query, @RequestParam(value="indexidentifier", required=false) String indexId) throws IndexServiceException {
        String indexClientKeys = format + "-" + layout + "-" + interpretation;
        IndexClient client = null;
        if (this.clientMap.getMap().containsKey(indexClientKeys)) {
            client = this.clientMap.getMap().get(indexClientKeys);
        } else {
            client = this.indexClientFactory.getClient(format, layout, interpretation);
            this.clientMap.getMap().put(indexClientKeys, client);
        }
        String mquery = query;
        if (!StringUtils.isEmpty((String)indexId)) {
            mquery = query + " and __dsid exact \"" + indexId + "\"";
        }
        return client.delete(mquery);
    }

    @RequestMapping(value={"/ui/index/search.do"}, method={RequestMethod.POST})
    @ResponseBody
    public LookupResponse search(ModelMap map, @RequestParam(value="backend", required=true) String backend, @RequestParam(value="format", required=true) String format, @RequestParam(value="layout", required=true) String layout, @RequestParam(value="interpretation", required=true) String interpretation, @RequestParam(value="query", required=true) String query, @RequestParam(value="from", required=true) int from, @RequestParam(value="number", required=true) int number, @RequestParam(value="indexidentifier", required=false) String indexId) throws IndexClientException {
        String indexClientKeys = format + "-" + layout + "-" + interpretation;
        log.debug((Object)indexClientKeys);
        IndexClient client = null;
        if (!this.clientMap.getMap().containsKey(indexClientKeys)) {
            this.clientMap.getMap().put(indexClientKeys, this.indexClientFactory.getClient(format, layout, interpretation));
        }
        client = this.clientMap.getMap().get(indexClientKeys);
        ArrayList filterId = null;
        if (indexId != null && !indexId.isEmpty()) {
            filterId = Lists.newArrayList((Object[])new String[]{"__dsid:\"" + indexId + "\""});
        }
        log.debug((Object)String.format("query: '%s', filter: '%s', from: '%d', number: '%d'", query, filterId, from, number));
        LookupResponse result = client.lookup(query, (List)filterId, from, number);
        ClassPathResource cpr = new ClassPathResource("/eu/dnetlib/functionality/modular/ui/xslt/gmf2document.xslt");
        ApplyXslt xslt = new ApplyXslt((org.springframework.core.io.Resource)cpr);
        ArrayList<String> convertedList = new ArrayList<String>();
        for (String s : result.getRecords()) {
            log.debug((Object)("response record: \n" + s));
            convertedList.add(xslt.evaluate((Object)s));
        }
        result.setRecords(convertedList);
        return result;
    }

    private List<String> quickSearchProfile(String xquery) throws Exception {
        try {
            return ((ISLookUpService)this.serviceLocator.getService(ISLookUpService.class)).quickSearchProfile(xquery);
        }
        catch (ISLookUpException e) {
            throw new Exception(e);
        }
    }
}

