/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.functionality.modular.ui.is.bulk;

import com.google.common.collect.Maps;
import eu.dnetlib.enabling.is.registry.rmi.ISRegistryService;
import eu.dnetlib.enabling.is.store.rmi.ISStoreService;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.enabling.tools.StreamOpaqueResource;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.ResourcePatternUtils;

public class ProfileImporter
implements ResourceLoaderAware {
    private ResourceLoader resourceLoader;
    private static final Log log = LogFactory.getLog(ProfileImporter.class);
    @Resource
    private UniqueServiceLocator serviceLocator;

    public Map<String, Integer> importSchemas(String path) throws IOException {
        int done = 0;
        int total = 0;
        for (org.springframework.core.io.Resource res : ResourcePatternUtils.getResourcePatternResolver((ResourceLoader)this.getResourceLoader()).getResources(path)) {
            ++total;
            try {
                this.registerSchema(res.getURL());
                ++done;
            }
            catch (Throwable e) {
                log.error((Object)("Error registering schema " + res.getURL()), e);
            }
        }
        HashMap res = Maps.newHashMap();
        res.put("schemasDone", done);
        res.put("schemasTotal", total);
        return res;
    }

    public Map<String, Integer> importProfiles(String path) throws IOException {
        int done = 0;
        int total = 0;
        for (org.springframework.core.io.Resource res : ResourcePatternUtils.getResourcePatternResolver((ResourceLoader)this.getResourceLoader()).getResources(path)) {
            ++total;
            try {
                this.registerProfile(res.getURL());
                ++done;
            }
            catch (Throwable e) {
                log.error((Object)("Error registering profile " + res.getURL()), e);
            }
        }
        HashMap res = Maps.newHashMap();
        res.put("profilesDone", done);
        res.put("profilesTotal", total);
        return res;
    }

    private void registerSchema(URL url) throws Exception {
        String resourceType = FilenameUtils.getBaseName((String)url.getPath());
        log.info((Object)("registering schema: " + resourceType));
        ((ISRegistryService)this.serviceLocator.getService(ISRegistryService.class)).addResourceType(resourceType, IOUtils.toString((InputStream)url.openStream()));
    }

    private void registerProfile(URL url) throws Exception {
        StreamOpaqueResource resource = new StreamOpaqueResource(url.openStream());
        String name = resource.getResourceId().split("_")[0];
        String coll = "/db/DRIVER/" + resource.getResourceKind() + "/" + resource.getResourceType();
        log.info((Object)("saving profile: " + name + " in coll " + coll));
        ((ISStoreService)this.serviceLocator.getService(ISStoreService.class)).insertXML(name, coll, resource.asString());
    }

    public ResourceLoader getResourceLoader() {
        return this.resourceLoader;
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }
}

