/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.common.logging;

import eu.dnetlib.common.logging.DnetLogLevel;
import eu.dnetlib.common.logging.LogMessage;
import eu.dnetlib.common.logging.conf.DnetLogConfigurationLoader;
import eu.dnetlib.common.logging.dao.DnetLoggerDao;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Required;

public class DnetLogger
implements Iterable<Map<String, String>> {
    private String name;
    private org.springframework.core.io.Resource indexConf;
    @Resource
    private DnetLoggerDao dao;

    @PostConstruct
    public void init() {
        this.dao.init(this.name);
        this.dao.configureIndex(this.name, DnetLogConfigurationLoader.getIndexedPaths(this.indexConf));
    }

    public LogMessage newLogMessage(DnetLogLevel level) {
        return new LogMessage(this.dao, this.name, level);
    }

    public LogMessage newLogMessage() {
        return this.newLogMessage(DnetLogLevel.INFO);
    }

    public Iterator<Map<String, String>> find(String key, String value) {
        return this.dao.find(this.name, key, value);
    }

    public Iterator<Map<String, String>> find(Map<String, Object> criteria) {
        return this.dao.find(this.name, criteria);
    }

    public Map<String, String> findOne(String key, String value) {
        return this.dao.findOne(this.name, key, value);
    }

    public Iterator<Map<String, String>> find(String cql, List<String> fields) {
        return this.dao.find(this.name, cql, fields);
    }

    @Override
    public Iterator<Map<String, String>> iterator() {
        return this.dao.obtainLogIterator(this.name);
    }

    public String getName() {
        return this.name;
    }

    @Required
    public void setName(String name) {
        this.name = name;
    }

    public org.springframework.core.io.Resource getIndexConf() {
        return this.indexConf;
    }

    public void setIndexConf(org.springframework.core.io.Resource indexConf) {
        this.indexConf = indexConf;
    }

    public Iterator<Map<String, String>> range(Date startDate, Date endDate) {
        return this.dao.findByDateRange(this.name, startDate, endDate);
    }

    public Iterator<Map<String, String>> range(Date startDate, Date endDate, String key, String value) {
        return this.dao.findByDateRange(this.name, startDate, endDate, key, value);
    }

    public Iterator<Map<String, String>> range(Date startDate, Date endDate, Map<String, Object> criteria) {
        return this.dao.findByDateRange(this.name, startDate, endDate, criteria);
    }
}

