/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.functionality.modular.ui.oai;

import com.google.common.base.Joiner;
import eu.dnetlib.functionality.modular.ui.AbstractAjaxController;
import eu.dnetlib.functionality.modular.ui.oai.objects.OaiRequest;
import eu.dnetlib.functionality.modular.ui.oai.objects.ResponseDetails;
import eu.dnetlib.miscutils.datetime.DateUtils;
import java.io.StringWriter;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.HttpClients;
import org.dom4j.Document;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class OaiExplorerInternalController
extends AbstractAjaxController {
    private static final Resource oaiXslt = new ClassPathResource("/eu/dnetlib/functionality/modular/ui/xslt/oai.xslt");
    private static final Log log = LogFactory.getLog(OaiExplorerInternalController.class);

    @RequestMapping(value={"/ui/oai_verb"})
    @ResponseBody
    public String oaiVerb(@RequestBody(required=true) OaiRequest req) throws Exception {
        return this.callOaiVerb(req);
    }

    @RequestMapping(value={"/ui/test_oai_verb"})
    @ResponseBody
    public ResponseDetails testOaiVerb(@RequestBody OaiRequest req) throws Exception {
        ResponseDetails response = new ResponseDetails();
        Document doc = this.callOaiVerb(req, response);
        if (response.isValid() && doc != null) {
            OaiRequest nextCall = new OaiRequest();
            nextCall.setBaseUrl(req.getBaseUrl());
            if ("Identify".equals(req.getVerb())) {
                nextCall.setVerb("ListSets");
            } else if ("ListSets".equals(req.getVerb())) {
                nextCall.setVerb("ListMetadataFormats");
            } else if ("ListMetadataFormats".equals(req.getVerb())) {
                nextCall.setVerb("ListRecords");
                if (doc.selectSingleNode("//*[local-name()='metadataPrefix' and text()='oai_dc']") != null) {
                    nextCall.setMdf("oai_dc");
                } else {
                    nextCall.setMdf(doc.selectSingleNode("//*[local-name()='metadataPrefix']").getText());
                }
            } else if ("ListRecords".equals(req.getVerb())) {
                nextCall.setVerb("ListIdentifiers");
                nextCall.setMdf(req.getMdf());
            } else if ("ListIdentifiers".equals(req.getVerb())) {
                nextCall.setVerb("GetRecord");
                nextCall.setMdf(req.getMdf());
                nextCall.setId(doc.selectSingleNode("//*[local-name()='identifier']").getText());
            } else if ("GetRecord".equals(req.getVerb())) {
                // empty if block
            }
            response.setNextCall(nextCall);
        }
        return response;
    }

    @RequestMapping(value={"/ui/test_harvesting"})
    @ResponseBody
    public ResponseDetails testHarvesting(@RequestBody OaiRequest req) throws Exception {
        Node node;
        ResponseDetails response = new ResponseDetails();
        Document doc = this.callOaiVerb(req, response);
        if (response.isValid() && doc != null && (node = doc.selectSingleNode("//*[local-name() = 'resumptionToken']")) != null) {
            response.setSize(doc.selectNodes("//*[local-name()='" + req.getVerb() + "']/*[local-name() != 'resumptionToken']").size());
            response.setCursor(NumberUtils.toInt((String)node.valueOf("@cursor"), (int)-1));
            response.setTotal(NumberUtils.toInt((String)node.valueOf("@completeListSize"), (int)-1));
            OaiRequest nextCall = new OaiRequest();
            nextCall.setBaseUrl(req.getBaseUrl());
            nextCall.setVerb(req.getVerb());
            nextCall.setToken(node.getText());
            response.setNextCall(nextCall);
        }
        return response;
    }

    private String callOaiVerb(OaiRequest req) throws Exception {
        HttpGet method = new HttpGet(!req.toQueryParams().isEmpty() ? req.getBaseUrl() + "?" + Joiner.on((String)"&").join(req.toQueryParams()) : req.getBaseUrl());
        method.addHeader("Content-type", "text/xml; charset=UTF-8");
        try (CloseableHttpResponse response = HttpClients.createDefault().execute((HttpUriRequest)method);){
            int responseCode = response.getStatusLine().getStatusCode();
            if (200 != responseCode) {
                log.error((Object)("Error downloading from baseUrl: " + req.getBaseUrl()));
                throw new RuntimeException("Error: " + responseCode);
            }
            TransformerFactory tfactory = TransformerFactory.newInstance();
            Transformer transformer = tfactory.newTransformer(new StreamSource(oaiXslt.getInputStream()));
            StringWriter output = new StringWriter();
            transformer.transform(new StreamSource(response.getEntity().getContent()), new StreamResult(output));
            String string = output.toString();
            return string;
        }
    }

    private Document callOaiVerb(OaiRequest req, ResponseDetails details) {
        HttpGet method = new HttpGet(!req.toQueryParams().isEmpty() ? req.getBaseUrl() + "?" + Joiner.on((String)"&").join(req.toQueryParams()) : req.getBaseUrl());
        method.addHeader("Content-type", "text/xml; charset=UTF-8");
        Document doc = null;
        long start = DateUtils.now();
        try (CloseableHttpResponse response = HttpClients.createDefault().execute((HttpUriRequest)method);){
            int responseCode = response.getStatusLine().getStatusCode();
            details.setHttpCode(responseCode);
            details.setValid(200 == responseCode);
            if (200 == responseCode) {
                try {
                    doc = new SAXReader().read(response.getEntity().getContent());
                }
                catch (Exception e) {
                    details.setValid(false);
                    details.setError(e.getMessage());
                }
            }
        }
        catch (Exception e) {
            details.setValid(false);
            details.setError(e.getMessage());
        }
        details.setTime(DateUtils.now() - start);
        details.setVerb(req.getVerb());
        return doc;
    }
}

