/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.objectstore.modular;

import eu.dnetlib.data.objectstore.modular.AbstractObjectStoreAction;
import eu.dnetlib.data.objectstore.modular.ObjectStoreProfileCreator;
import eu.dnetlib.data.objectstore.rmi.ObjectStoreServiceException;
import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.enabling.tools.blackboard.BlackboardServerHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CreateObjectStoreAction
extends AbstractObjectStoreAction {
    private static final Log log = LogFactory.getLog(CreateObjectStoreAction.class);
    private ObjectStoreProfileCreator profileCreator;

    public ObjectStoreProfileCreator getProfileCreator() {
        return this.profileCreator;
    }

    public void setProfileCreator(ObjectStoreProfileCreator profileCreator) {
        this.profileCreator = profileCreator;
    }

    @Override
    protected void executeAsync(BlackboardServerHandler handler, BlackboardJob job) {
        try {
            String interpretation = (String)job.getParameters().get("interpretation");
            String objID = this.profileCreator.registerProfile(interpretation);
            try {
                this.getDao().createObjectStore(objID, interpretation, null);
            }
            catch (Throwable e) {
                log.warn((Object)"cannot created objectStore, deleting profile");
                this.profileCreator.deleteProfile(objID);
                throw new ObjectStoreServiceException(e);
            }
            job.getParameters().put("objectStoreId", objID);
            this.completeWithSuccess(handler, job);
        }
        catch (Exception e) {
            this.completeWithFail(handler, job, e);
        }
    }
}

