/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.objectstore.modular;

import com.google.gson.Gson;
import eu.dnetlib.data.objectstore.modular.ModularObjectStoreDeliver;
import eu.dnetlib.data.objectstore.modular.ModularObjectStoreFeeder;
import eu.dnetlib.data.objectstore.modular.ObjectStoreRecord;
import eu.dnetlib.data.objectstore.rmi.ObjectStoreFile;
import eu.dnetlib.data.objectstore.rmi.ObjectStoreService;
import eu.dnetlib.data.objectstore.rmi.ObjectStoreServiceException;
import eu.dnetlib.enabling.tools.AbstractBaseService;
import eu.dnetlib.enabling.tools.blackboard.NotificationHandler;
import java.util.List;
import javax.xml.ws.wsaddressing.W3CEndpointReference;
import org.springframework.beans.factory.annotation.Required;

public class ModularObjectStoreService
extends AbstractBaseService
implements ObjectStoreService {
    private ModularObjectStoreFeeder feeder;
    private ModularObjectStoreDeliver objectStoreDeliver;
    private NotificationHandler notificationHandler;

    public W3CEndpointReference deliverObjects(String obsId, Long from, Long until) throws ObjectStoreServiceException {
        return this.objectStoreDeliver.deliver(obsId, from, until);
    }

    public W3CEndpointReference deliverObjectsByIds(String obsId, W3CEndpointReference eprId) throws ObjectStoreServiceException {
        return this.objectStoreDeliver.deliverIds(obsId, eprId);
    }

    public String deliverRecord(String obsId, String objectId) throws ObjectStoreServiceException {
        return this.objectStoreDeliver.deliverObject(obsId, objectId).toJSON();
    }

    public List<String> getListOfObjectStores() {
        return this.objectStoreDeliver.getDao().listObjectStores();
    }

    public ModularObjectStoreFeeder getFeeder() {
        return this.feeder;
    }

    @Required
    public void setFeeder(ModularObjectStoreFeeder feeder) {
        this.feeder = feeder;
    }

    public NotificationHandler getNotificationHandler() {
        return this.notificationHandler;
    }

    @Required
    public void setNotificationHandler(NotificationHandler notificationHandler) {
        this.notificationHandler = notificationHandler;
    }

    public void notify(String subscriptionId, String topic, String isId, String message) {
        this.getNotificationHandler().notified(subscriptionId, topic, isId, message);
    }

    public ModularObjectStoreDeliver getObjectStoreDeliver() {
        return this.objectStoreDeliver;
    }

    @Required
    public void setObjectStoreDeliver(ModularObjectStoreDeliver objectStoreDeliver) {
        this.objectStoreDeliver = objectStoreDeliver;
    }

    public void feedObject(String obsId, String objectMetadata) throws ObjectStoreServiceException {
        Gson g = new Gson();
        try {
            ObjectStoreFile file = (ObjectStoreFile)g.fromJson(objectMetadata, ObjectStoreFile.class);
            this.feeder.feedObject(obsId, file.getObjectID(), file.getURI(), file.getAccessProtocol(), file.getUsernameAuth(), file.getPasswordAuth(), file.getMimeType());
        }
        catch (Exception e) {
            throw new ObjectStoreServiceException(e.getMessage());
        }
    }

    public boolean existIDStartsWith(String obsId, String startId) throws ObjectStoreServiceException {
        return this.objectStoreDeliver.existIDStartsWith(obsId, startId);
    }

    public String feedObject(String obsId, ObjectStoreRecord record) throws ObjectStoreServiceException {
        try {
            return this.feeder.feedObjectRecord(obsId, record);
        }
        catch (Exception e) {
            throw new ObjectStoreServiceException(e.getMessage());
        }
    }

    public int getSize(String obsId) throws ObjectStoreServiceException {
        return this.objectStoreDeliver.getDao().getObjectStore(obsId).getSize();
    }
}

