/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.functionality.modular.ui.repositories;

import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.gson.Gson;
import eu.dnetlib.enabling.datasources.common.Api;
import eu.dnetlib.enabling.datasources.common.Datasource;
import eu.dnetlib.enabling.datasources.common.LocalDatasourceManager;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.functionality.modular.ui.ModuleEntryPoint;
import eu.dnetlib.functionality.modular.ui.repositories.RepoUIUtils;
import eu.dnetlib.miscutils.collections.Pair;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.dom4j.Document;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.ui.ModelMap;

public class RepoApisEntryPointController
extends ModuleEntryPoint {
    @Resource
    private UniqueServiceLocator serviceLocator;
    @Resource
    private RepoUIUtils repoUIUtils;
    private String compatibilityLevelsVocabulary;
    private String validatorAddress;
    private String validatorServiceAddress;
    @Autowired
    private LocalDatasourceManager<Datasource<?, ?>, Api<?>> dsManager;

    private RepoHIWorkflow parseQuery(String input) {
        SAXReader reader = new SAXReader();
        try {
            Document doc = reader.read((Reader)new StringReader(input));
            String id = doc.valueOf("//id");
            String name = doc.valueOf("//name");
            String type = doc.valueOf("//types");
            String compliance = doc.valueOf("//compliances");
            HashSet ifcTypes = Sets.newHashSet((Iterable)Splitter.on((String)",").omitEmptyStrings().trimResults().split((CharSequence)type));
            HashSet compliances = Sets.newHashSet((Iterable)Splitter.on((String)",").omitEmptyStrings().trimResults().split((CharSequence)compliance));
            ArrayList<Pair<String, String>> fields = new ArrayList<Pair<String, String>>();
            for (Object o : doc.selectNodes(".//FIELD")) {
                Node currentNode = (Node)o;
                String key = currentNode.valueOf("@name");
                String value = currentNode.getText();
                fields.add((Pair<String, String>)new Pair((Object)key, (Object)value));
            }
            return new RepoHIWorkflow(id, name, ifcTypes, compliances, fields);
        }
        catch (Exception e) {
            return null;
        }
    }

    private List<RepoHIWorkflow> listRepoHIWorkflows() throws ISLookUpException {
        String xquery = "for $x in collection('/db/DRIVER/WorkflowDSResources/WorkflowDSResourceType') where $x//WORKFLOW_TYPE='REPO_HI' return <result> <id>{$x//RESOURCE_IDENTIFIER/@value/string()}</id> <name>{$x//WORKFLOW_NAME/text()}</name> <types>{$x//PARAM[@name='expectedInterfaceTypologyPrefixes']/text()}</types> <compliances>{$x//PARAM[@name='expectedCompliancePrefixes']/text()}</compliances> {$x//FIELD} </result>";
        ArrayList list = Lists.newArrayList();
        for (String s : ((ISLookUpService)this.serviceLocator.getService(ISLookUpService.class)).quickSearchProfile("for $x in collection('/db/DRIVER/WorkflowDSResources/WorkflowDSResourceType') where $x//WORKFLOW_TYPE='REPO_HI' return <result> <id>{$x//RESOURCE_IDENTIFIER/@value/string()}</id> <name>{$x//WORKFLOW_NAME/text()}</name> <types>{$x//PARAM[@name='expectedInterfaceTypologyPrefixes']/text()}</types> <compliances>{$x//PARAM[@name='expectedCompliancePrefixes']/text()}</compliances> {$x//FIELD} </result>")) {
            RepoHIWorkflow repoHiInfo = this.parseQuery(s);
            if (repoHiInfo == null) continue;
            list.add(repoHiInfo);
        }
        Collections.sort(list);
        return list;
    }

    protected void initialize(ModelMap map, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Gson gson = new Gson();
        map.addAttribute("availableRepohiWfs", (Object)gson.toJson(this.listRepoHIWorkflows()));
        map.addAttribute("compatibilityLevels", (Object)gson.toJson(this.repoUIUtils.fetchVocabularyTerms(this.getCompatibilityLevelsVocabulary())));
        map.addAttribute("browseFields", (Object)gson.toJson((Object)this.dsManager.listBrowsableFields()));
        map.addAttribute("validatorAddress", (Object)this.getValidatorAddress());
        map.addAttribute("validatorServiceAddress", (Object)this.getValidatorServiceAddress());
    }

    public String getCompatibilityLevelsVocabulary() {
        return this.compatibilityLevelsVocabulary;
    }

    @Required
    public void setCompatibilityLevelsVocabulary(String compatibilityLevelsVocabulary) {
        this.compatibilityLevelsVocabulary = compatibilityLevelsVocabulary;
    }

    public String getValidatorAddress() {
        return this.validatorAddress;
    }

    @Required
    public void setValidatorAddress(String validatorAddress) {
        this.validatorAddress = validatorAddress;
    }

    public String getValidatorServiceAddress() {
        return this.validatorServiceAddress;
    }

    @Required
    public void setValidatorServiceAddress(String validatorServiceAddress) {
        this.validatorServiceAddress = validatorServiceAddress;
    }

    public class RepoHIWorkflow
    implements Comparable<RepoHIWorkflow> {
        private final String id;
        private final String name;
        private final Set<String> ifaceTypes;
        private final Set<String> compliances;
        private List<Pair<String, String>> fields;

        public RepoHIWorkflow(String id, String name, Set<String> ifaceTypes, Set<String> compliances, List<Pair<String, String>> fields) {
            this.id = id;
            this.name = name;
            this.ifaceTypes = ifaceTypes;
            this.compliances = compliances;
            this.fields = fields;
        }

        public String getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public Set<String> getIfaceTypes() {
            return this.ifaceTypes;
        }

        public Set<String> getCompliances() {
            return this.compliances;
        }

        @Override
        public int compareTo(RepoHIWorkflow o) {
            return this.getName().compareTo(o.getName());
        }

        public List<Pair<String, String>> getFields() {
            return this.fields;
        }

        public void setFields(List<Pair<String, String>> fields) {
            this.fields = fields;
        }
    }
}

