/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.functionality.modular.ui.repositories;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import eu.dnetlib.data.collector.rmi.CollectorService;
import eu.dnetlib.data.collector.rmi.ProtocolDescriptor;
import eu.dnetlib.data.collector.rmi.ProtocolParameter;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.functionality.modular.ui.repositories.objects.RepoInterfaceEntry;
import eu.dnetlib.functionality.modular.ui.repositories.objects.RepoMetaWfEntry;
import eu.dnetlib.functionality.modular.ui.repositories.objects.SimpleParamEntry;
import eu.dnetlib.functionality.modular.ui.repositories.objects.VocabularyEntry;
import eu.dnetlib.msro.workflows.util.WorkflowsConstants;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import org.antlr.stringtemplate.StringTemplate;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;
import org.springframework.core.io.ClassPathResource;

public class RepoUIUtils {
    @Resource
    private UniqueServiceLocator serviceLocator;
    private final ClassPathResource getRepoApiQueryTmpl = new ClassPathResource("/eu/dnetlib/functionality/modular/ui/repositories/templates/getRepoApi.xquery.st");
    private static final Log log = LogFactory.getLog(RepoUIUtils.class);
    private final Map<String, List<ProtocolParameter>> parametersMap = Maps.newHashMap();

    public RepoInterfaceEntry getApi(String repoId, String ifaceId) throws Exception {
        Node n;
        RepoInterfaceEntry ifc = new RepoInterfaceEntry();
        StringTemplate st = new StringTemplate(IOUtils.toString((InputStream)this.getRepoApiQueryTmpl.getInputStream()));
        st.setAttribute("dsId", (Object)repoId);
        st.setAttribute("ifaceId", (Object)ifaceId);
        String query = st.toString();
        SAXReader reader = new SAXReader();
        String s = ((ISLookUpService)this.serviceLocator.getService(ISLookUpService.class)).getResourceProfileByQuery(query);
        Document doc = reader.read((Reader)new StringReader(s));
        ifc.setId(doc.valueOf("/api/id"));
        ifc.setLabel(doc.valueOf("/api/label"));
        ifc.setRemovable(doc.valueOf("/api/removable").equalsIgnoreCase("true") && doc.selectNodes("//metaWF").isEmpty());
        ifc.setRepoId(doc.valueOf("/api/repo/@id"));
        ifc.setRepoName(StringEscapeUtils.unescapeHtml((String)doc.valueOf("/api/repo")));
        ifc.setRepoCountry(doc.valueOf("/api/repo/@country"));
        ifc.setRepoPrefix(doc.valueOf("/api/repo/@prefix"));
        ifc.setRepoType(doc.valueOf("/api/repo/@type"));
        ifc.setEmail(doc.valueOf("/api/repo/@email"));
        String protocol = doc.valueOf("/api/protocol");
        ifc.setProtocol(protocol);
        Set<String> toVerifyParams = this.getParameterNamesForProtocol(ifc.getProtocol());
        for (Object o : doc.selectNodes("/api/commonParams/param")) {
            n = (Node)o;
            ifc.getCommonParams().add(new SimpleParamEntry(n.valueOf("@name"), n.getText()));
        }
        log.debug((Object)("****** " + toVerifyParams));
        for (Object o : doc.selectNodes("/api/accessParams/param")) {
            n = (Node)o;
            String pname = n.valueOf("@name");
            if (toVerifyParams.contains(pname)) {
                ifc.getAccessParams().add(new SimpleParamEntry(pname, n.getText()));
                toVerifyParams.remove(pname);
                continue;
            }
            log.warn((Object)("Invalid param [" + pname + "] for protocol " + protocol + " in repo " + repoId));
        }
        for (String pname : toVerifyParams) {
            ifc.getAccessParams().add(new SimpleParamEntry(pname, ""));
            log.info((Object)("Adding missing param [" + pname + "] for protocol " + protocol + " in repo " + repoId));
        }
        for (Object o : doc.selectNodes("/api/extraFields/field")) {
            n = (Node)o;
            String name = n.valueOf("@name");
            String value = n.getText();
            if (name.equalsIgnoreCase("overriding_compliance")) {
                for (SimpleParamEntry e : ifc.getCommonParams()) {
                    if (!e.getName().equals("compliance")) continue;
                    e.setOtherValue(value);
                }
                continue;
            }
            if (name.equalsIgnoreCase("last_aggregation_date")) {
                ifc.setAggrDate(value);
                continue;
            }
            if (name.equalsIgnoreCase("last_aggregation_total")) {
                ifc.setAggrTotal(NumberUtils.toInt((String)value, (int)0));
                continue;
            }
            if (name.equalsIgnoreCase("last_aggregation_mdId")) {
                ifc.setAggrMdId(value);
                continue;
            }
            if (name.equalsIgnoreCase("last_collection_date")) {
                ifc.setCollDate(value);
                continue;
            }
            if (name.equalsIgnoreCase("last_collection_total")) {
                ifc.setCollTotal(NumberUtils.toInt((String)value, (int)0));
                continue;
            }
            if (name.equalsIgnoreCase("last_collection_mdId")) {
                ifc.setCollMdId(value);
                continue;
            }
            if (name.equalsIgnoreCase("last_download_date")) {
                ifc.setDownloadDate(value);
                continue;
            }
            if (name.equalsIgnoreCase("last_download_total")) {
                ifc.setDownloadTotal(NumberUtils.toInt((String)value, (int)0));
                continue;
            }
            if (name.equalsIgnoreCase("last_download_objId")) {
                ifc.setDownloadObjId(value);
                continue;
            }
            ifc.getOtherParams().add(new SimpleParamEntry(name, value));
        }
        if (doc.selectNodes("/api/extraFields/field[@name='metadata_identifier_path']").isEmpty()) {
            ifc.getOtherParams().add(new SimpleParamEntry("metadata_identifier_path", ""));
        }
        for (Object o : doc.selectNodes("//metaWF")) {
            n = (Node)o;
            String id = n.valueOf("./id");
            String name = n.valueOf("./name");
            String status = n.valueOf("./status");
            String repoByeWfId = n.valueOf("./destroyWorkflow");
            int progress = 0;
            try {
                switch (WorkflowsConstants.WorkflowStatus.valueOf((String)status)) {
                    case MISSING: {
                        progress = 0;
                        break;
                    }
                    case ASSIGNED: {
                        progress = 25;
                        break;
                    }
                    case WAIT_SYS_SETTINGS: {
                        progress = 50;
                        break;
                    }
                    case WAIT_USER_SETTINGS: {
                        progress = 75;
                        break;
                    }
                    case EXECUTABLE: {
                        progress = 100;
                    }
                }
            }
            catch (Exception e) {
                progress = 0;
            }
            ifc.getMetaWFs().add(new RepoMetaWfEntry(id, name, status, repoByeWfId, progress));
        }
        return ifc;
    }

    public List<VocabularyEntry> fetchVocabularyTerms(String voc) throws ISLookUpException {
        String xquery = "for $x in collection('/db/DRIVER/VocabularyDSResources/VocabularyDSResourceType')[.//VOCABULARY_NAME/@code = '" + voc.trim() + "']//TERM return concat($x/@code, ' @@@ ', $x/@english_name)";
        ArrayList list = Lists.newArrayList();
        for (String s : ((ISLookUpService)this.serviceLocator.getService(ISLookUpService.class)).quickSearchProfile(xquery)) {
            String[] arr = s.split("@@@");
            list.add(new VocabularyEntry(arr[0].trim(), arr[1].trim()));
        }
        Collections.sort(list);
        return list;
    }

    private Set<String> getParameterNamesForProtocol(String protocol) {
        if (this.parametersMap.isEmpty()) {
            for (ProtocolDescriptor d : ((CollectorService)this.serviceLocator.getService(CollectorService.class)).listProtocols()) {
                this.parametersMap.put(d.getName().toLowerCase(), d.getParams());
            }
        }
        HashSet res = Sets.newHashSet();
        if (this.parametersMap.containsKey(protocol.toLowerCase())) {
            res.add("baseUrl");
            for (ProtocolParameter p : this.parametersMap.get(protocol.toLowerCase())) {
                res.add(p.getName());
            }
        }
        return res;
    }
}

