/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.functionality.modular.ui.repositories;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import eu.dnetlib.data.collector.rmi.CollectorService;
import eu.dnetlib.data.collector.rmi.ProtocolDescriptor;
import eu.dnetlib.data.collector.rmi.ProtocolParameter;
import eu.dnetlib.enabling.datasources.DatasourceFunctions;
import eu.dnetlib.enabling.datasources.LocalOpenaireDatasourceManager;
import eu.dnetlib.enabling.datasources.common.Api;
import eu.dnetlib.enabling.datasources.common.ApiParam;
import eu.dnetlib.enabling.datasources.common.BrowsableField;
import eu.dnetlib.enabling.datasources.common.Datasource;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.functionality.modular.ui.repositories.objects.RepoInterfaceEntry;
import eu.dnetlib.functionality.modular.ui.repositories.objects.RepoMetaWfEntry;
import eu.dnetlib.functionality.modular.ui.repositories.objects.SimpleParamEntry;
import eu.dnetlib.functionality.modular.ui.repositories.objects.VocabularyEntry;
import eu.dnetlib.miscutils.datetime.DateUtils;
import eu.dnetlib.msro.workflows.util.WorkflowsConstants;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.antlr.stringtemplate.StringTemplate;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

public class RepoUIUtils {
    @Autowired
    private UniqueServiceLocator serviceLocator;
    @Autowired
    private LocalOpenaireDatasourceManager dsManager;
    @Value(value="${repo.ui.tickets.baseUrl}")
    private String ticketBaseUrl;
    private static final Log log = LogFactory.getLog(RepoUIUtils.class);
    private final Map<String, List<ProtocolParameter>> parametersMap = Maps.newHashMap();

    public RepoInterfaceEntry getApi(String dsId, String apiId) throws Exception {
        RepoInterfaceEntry ifc = new RepoInterfaceEntry();
        Datasource ds = this.dsManager.getDs(dsId);
        Api api = this.dsManager.getApis(dsId).stream().filter(a -> a.getId().equals(apiId)).findFirst().orElseThrow(() -> new Exception("Api not found"));
        ArrayList metaWfs = new ArrayList();
        ifc.setId(api.getId());
        ifc.setLabel(String.format("%s (%s)", StringUtils.defaultIfBlank((CharSequence)ds.getEoscDatasourceType(), (CharSequence)"-"), StringUtils.defaultIfBlank((CharSequence)api.getCompatibility(), (CharSequence)"-")));
        ifc.setRemovable(api.getRemovable() != false && metaWfs.isEmpty());
        ifc.setRepoId(ds.getId());
        ifc.setRepoName(ds.getOfficialname());
        ifc.setRepoCountry(ds.getOrganizations().stream().map(o -> o.getCountry()).filter(o -> o != null).findFirst().orElse("UNKNOWN"));
        ifc.setRepoPrefix(ds.getNamespaceprefix());
        ifc.setRepoType(ds.getEoscDatasourceType());
        ifc.setEmail(ds.getContactemail());
        ifc.setActive(api.getActive());
        ifc.setProtocol(api.getProtocol());
        ifc.setConsentTermsOfUseLabel(BooleanUtils.toString((Boolean)ds.getConsentTermsOfUse(), (String)"YES", (String)"NO", (String)"UNKNOWN"));
        ifc.setFullTextDownloadLabel(BooleanUtils.toString((Boolean)ds.getFullTextDownload(), (String)"YES", (String)"NO", (String)"UNKNOWN"));
        Set<String> toVerifyParams = this.getParameterNamesForProtocol(ifc.getProtocol());
        ifc.getAccessParams().add(new SimpleParamEntry("baseUrl", api.getBaseurl()));
        for (ApiParam p : api.getApiParams()) {
            if (toVerifyParams.contains(p.getParam())) {
                ifc.getAccessParams().add(new SimpleParamEntry(p.getParam(), p.getValue()));
                toVerifyParams.remove(p.getParam());
                continue;
            }
            log.warn((Object)("Invalid param [" + p.getParam() + "] for protocol " + p.getValue() + " in ds " + dsId));
        }
        for (String pname : toVerifyParams) {
            ifc.getAccessParams().add(new SimpleParamEntry(pname, ""));
            log.info((Object)("Adding missing param [" + pname + "] for protocol " + api.getProtocol() + " in ds " + dsId));
        }
        ifc.setMetadataIdentifierPath(api.getMetadataIdentifierPath());
        ifc.setCompliance(api.getCompatibility());
        ifc.setComplianceOverrided(api.isCompatibilityOverrided());
        if (api.getLastAggregationDate() != null) {
            ifc.setAggrDate(DateUtils.calculate_ISO8601((long)api.getLastAggregationDate().getTime()));
            ifc.setAggrTotal(api.getLastAggregationTotal());
            ifc.setAggrMdId(api.getLastAggregationMdid());
            ifc.setAggrBackend(DatasourceFunctions.calculateMdstoreBackendById((String)api.getLastAggregationMdid()));
        }
        if (api.getLastCollectionDate() != null) {
            ifc.setCollDate(DateUtils.calculate_ISO8601((long)api.getLastCollectionDate().getTime()));
            ifc.setCollTotal(api.getLastCollectionTotal());
            ifc.setCollMdId(api.getLastCollectionMdid());
            ifc.setCollBackend(DatasourceFunctions.calculateMdstoreBackendById((String)api.getLastCollectionMdid()));
        }
        if (api.getLastDownloadDate() != null) {
            ifc.setDownloadDate(DateUtils.calculate_ISO8601((long)api.getLastDownloadDate().getTime()));
            ifc.setDownloadTotal(api.getLastDownloadTotal());
            ifc.setDownloadObjId(api.getLastDownloadObjid());
        }
        ifc.setTickets(this.findTicketsForDatasource(dsId));
        StringTemplate st = new StringTemplate(IOUtils.toString((InputStream)this.getClass().getResourceAsStream("/eu/dnetlib/functionality/modular/ui/repositories/templates/getMetaWfs.xquery.st")));
        st.setAttribute("dsId", (Object)dsId);
        st.setAttribute("apiId", (Object)apiId);
        String s = ((ISLookUpService)this.serviceLocator.getService(ISLookUpService.class)).getResourceProfileByQuery(st.toString());
        Document doc = new SAXReader().read((Reader)new StringReader(s));
        for (Object o2 : doc.selectNodes("//metaWF")) {
            Node n = (Node)o2;
            String id = n.valueOf("./id");
            String name = n.valueOf("./name");
            String status = n.valueOf("./status");
            String repoByeWfId = n.valueOf("./destroyWorkflow");
            int progress = 0;
            try {
                switch (WorkflowsConstants.WorkflowStatus.valueOf((String)status)) {
                    case MISSING: {
                        progress = 0;
                        break;
                    }
                    case ASSIGNED: {
                        progress = 25;
                        break;
                    }
                    case WAIT_SYS_SETTINGS: {
                        progress = 50;
                        break;
                    }
                    case WAIT_USER_SETTINGS: {
                        progress = 75;
                        break;
                    }
                    case EXECUTABLE: {
                        progress = 100;
                    }
                }
            }
            catch (Exception e) {
                progress = 0;
            }
            ifc.getMetaWFs().add(new RepoMetaWfEntry(id, name, status, repoByeWfId, progress));
        }
        return ifc;
    }

    private List<BrowsableField> findTicketsForDatasource(String dsId) throws Exception {
        return this.dsManager.listTickets(dsId).stream().sorted().map(i -> new BrowsableField(this.ticketBaseUrl + i, "#" + i)).collect(Collectors.toList());
    }

    public List<BrowsableField> updateTicketsForDatasource(String dsId, Set<Integer> tickets) throws Exception {
        this.dsManager.updateTickets(dsId, tickets);
        return this.findTicketsForDatasource(dsId);
    }

    public List<VocabularyEntry> fetchVocabularyTerms(String voc) throws ISLookUpException {
        String xquery = "for $x in collection('/db/DRIVER/VocabularyDSResources/VocabularyDSResourceType')[.//VOCABULARY_NAME/@code = '" + voc.trim() + "']//TERM return concat($x/@code, ' @@@ ', $x/@english_name)";
        ArrayList list = Lists.newArrayList();
        for (String s : ((ISLookUpService)this.serviceLocator.getService(ISLookUpService.class)).quickSearchProfile(xquery)) {
            String[] arr = s.split("@@@");
            list.add(new VocabularyEntry(arr[0].trim(), arr[1].trim()));
        }
        Collections.sort(list);
        return list;
    }

    private Set<String> getParameterNamesForProtocol(String protocol) {
        if (this.parametersMap.isEmpty()) {
            for (ProtocolDescriptor d : ((CollectorService)this.serviceLocator.getService(CollectorService.class)).listProtocols()) {
                this.parametersMap.put(d.getName().toLowerCase(), d.getParams());
            }
        }
        HashSet res = Sets.newHashSet();
        if (this.parametersMap.containsKey(protocol.toLowerCase())) {
            for (ProtocolParameter p : this.parametersMap.get(protocol.toLowerCase())) {
                res.add(p.getName());
            }
        }
        return res;
    }
}

