/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.functionality.modular.ui.users;

import com.google.gson.Gson;
import eu.dnetlib.functionality.modular.ui.users.AuthorizationDAO;
import eu.dnetlib.functionality.modular.ui.users.AuthorizationManager;
import eu.dnetlib.functionality.modular.ui.users.PermissionLevel;
import eu.dnetlib.functionality.modular.ui.users.User;
import java.io.InputStream;
import java.net.URLDecoder;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.Signature;
import java.security.spec.X509EncodedKeySpec;
import java.util.Map;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;

public class SimpleSSOAuthorizationManager
implements AuthorizationManager {
    private static final Log log = LogFactory.getLog(SimpleSSOAuthorizationManager.class);
    private Resource pubKeyFile = new ClassPathResource("/eu/dnetlib/functionality/modular/ui/users/pubkey.der");
    private String pubKeyAlgo = "RSA";
    private String signatureAlgo = "SHA1withRSA";
    private PublicKey publicKey;
    private AuthorizationDAO authorizationDAO;
    private String defaultSuperAdmin;

    @Override
    public User obtainUserDetails(HttpServletRequest request) {
        if (request.getCookies() != null) {
            for (Cookie cookie : request.getCookies()) {
                if (!cookie.getName().equalsIgnoreCase("rinfra-user")) continue;
                try {
                    return this.processCookie(cookie.getValue());
                }
                catch (Exception e) {
                    log.error((Object)("Error processing cookie: " + cookie.getValue()), (Throwable)e);
                    return null;
                }
            }
        }
        return null;
    }

    private User processCookie(String s) throws Exception {
        Map userMap;
        String signature;
        if (s == null || s.isEmpty()) {
            return null;
        }
        Gson gson = new Gson();
        Map map = (Map)gson.fromJson(new String(Base64.decodeBase64((String)URLDecoder.decode(s.trim(), "UTF-8"))), Map.class);
        String message = (String)map.get("payload");
        if (this.isValidMessage(message, signature = (String)map.get("signature")) && (userMap = (Map)gson.fromJson(message, Map.class)).containsKey("uid")) {
            String uid = (String)userMap.get("uid");
            User user = new User(uid);
            user.setEmail((String)userMap.get("email"));
            user.setFullname(userMap.containsKey("fullname") ? (String)userMap.get("fullname") : uid);
            user.setPermissionLevels(this.authorizationDAO.getPermissionLevels(uid));
            if (this.isDefaultSuperAdmin(uid)) {
                user.getPermissionLevels().add(PermissionLevel.SUPER_ADMIN);
            }
            return user;
        }
        return null;
    }

    private boolean isDefaultSuperAdmin(String uid) {
        return uid != null && !uid.isEmpty() && uid.equals(this.getDefaultSuperAdmin());
    }

    protected boolean isValidMessage(String message, String signature) {
        log.info((Object)("checking message " + message + " with sig " + signature));
        if (message == null || message.isEmpty() || signature == null || signature.isEmpty()) {
            log.error((Object)"Null  or empty values in message or signature");
            return false;
        }
        try {
            Signature sg = Signature.getInstance(this.getSignatureAlgo());
            sg.initVerify(this.getPublicKey());
            sg.update(message.getBytes());
            return sg.verify(Hex.decodeHex((char[])signature.toCharArray()));
        }
        catch (Exception e) {
            log.error((Object)"Error verifyng signature", (Throwable)e);
            return false;
        }
    }

    public void init() throws Exception {
        byte[] keyBytes = IOUtils.toByteArray((InputStream)this.getPubKeyFile().getInputStream());
        X509EncodedKeySpec spec = new X509EncodedKeySpec(keyBytes);
        this.setPublicKey(KeyFactory.getInstance(this.getPubKeyAlgo()).generatePublic(spec));
    }

    public Resource getPubKeyFile() {
        return this.pubKeyFile;
    }

    @Required
    public void setPubKeyFile(Resource pubKeyFile) {
        this.pubKeyFile = pubKeyFile;
    }

    public String getPubKeyAlgo() {
        return this.pubKeyAlgo;
    }

    @Required
    public void setPubKeyAlgo(String pubKeyAlgo) {
        this.pubKeyAlgo = pubKeyAlgo;
    }

    public String getSignatureAlgo() {
        return this.signatureAlgo;
    }

    @Required
    public void setSignatureAlgo(String signatureAlgo) {
        this.signatureAlgo = signatureAlgo;
    }

    public PublicKey getPublicKey() {
        return this.publicKey;
    }

    public void setPublicKey(PublicKey publicKey) {
        this.publicKey = publicKey;
    }

    public AuthorizationDAO getAuthorizationDAO() {
        return this.authorizationDAO;
    }

    @Required
    public void setAuthorizationDAO(AuthorizationDAO authorizationDAO) {
        this.authorizationDAO = authorizationDAO;
    }

    public String getDefaultSuperAdmin() {
        return this.defaultSuperAdmin;
    }

    @Required
    public void setDefaultSuperAdmin(String defaultSuperAdmin) {
        this.defaultSuperAdmin = defaultSuperAdmin;
    }
}

