/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.functionality.modular.ui.utils;

import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Queues;
import eu.dnetlib.functionality.modular.ui.utils.LogLine;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.spi.LoggingEvent;

public class LogUiAppender
extends AppenderSkeleton {
    public static final int MAX_LOGS_IN_QUEUE = 2000;
    private final LinkedBlockingQueue<LogLine> logQueue = Queues.newLinkedBlockingQueue((int)2000);
    private int count = 0;
    private static final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void append(LoggingEvent event) {
        LinkedBlockingQueue<LogLine> linkedBlockingQueue = this.logQueue;
        synchronized (linkedBlockingQueue) {
            if (this.logQueue.remainingCapacity() == 0) {
                this.logQueue.poll();
            }
            try {
                String date = dateFormat.format(new Date(event.getTimeStamp()));
                Object[] arr = event.getThrowableStrRep();
                String strace = arr != null && arr.length > 0 ? Joiner.on((String)"\n").join(arr) : "";
                this.logQueue.put(new LogLine(this.count++, event.getLevel().toString(), event.getLoggerName(), date, event.getRenderedMessage(), strace));
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<LogLine> tail_N(int n) throws Exception {
        LinkedBlockingQueue<LogLine> linkedBlockingQueue = this.logQueue;
        synchronized (linkedBlockingQueue) {
            int qSize = this.logQueue.size();
            if (n <= 0 || qSize == 0) {
                return Lists.newArrayList();
            }
            if (n < qSize) {
                return Lists.newArrayList(this.logQueue).subList(qSize - n, qSize);
            }
            return Lists.newArrayList(this.logQueue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<LogLine> tail_continue(final int after) throws Exception {
        LinkedBlockingQueue<LogLine> linkedBlockingQueue = this.logQueue;
        synchronized (linkedBlockingQueue) {
            return Lists.newArrayList((Iterable)Iterables.filter(this.logQueue, (Predicate)new Predicate<LogLine>(){

                public boolean apply(LogLine ll) {
                    return ll.getId() > (long)after;
                }
            }));
        }
    }

    public void close() {
    }

    public boolean requiresLayout() {
        return false;
    }
}

