/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.functionality.modular.ui;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import eu.dnetlib.functionality.modular.ui.ModuleEntryPoint;
import eu.dnetlib.miscutils.datetime.DateUtils;
import eu.dnetlib.miscutils.datetime.HumanTime;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.maven.model.Model;
import org.apache.maven.model.Parent;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.ResourcePatternUtils;
import org.springframework.ui.ModelMap;

public class InfoController
extends ModuleEntryPoint
implements ResourceLoaderAware {
    private String hostname;
    private String port;
    private String context;
    private ResourceLoader resourceLoader;
    private static final Log log = LogFactory.getLog(InfoController.class);

    @Override
    protected void initialize(ModelMap map, HttpServletRequest request, HttpServletResponse response) throws Exception {
        RuntimeMXBean mxbean = ManagementFactory.getRuntimeMXBean();
        LinkedHashMap info = Maps.newLinkedHashMap();
        info.put("General", this.getGeneralInfo(mxbean));
        info.put("JVM", this.getJvmInfo(mxbean));
        info.put("Libraries and arguments", this.getLibInfo(mxbean));
        info.put("System properties", this.getSysInfo(mxbean));
        map.addAttribute("info", (Object)info);
        map.addAttribute("modules", this.getModules());
    }

    private List<Map<String, Object>> getModules() throws IOException {
        LinkedHashMap modules = Maps.newLinkedHashMap();
        MavenXpp3Reader reader = new MavenXpp3Reader();
        for (Resource res : ResourcePatternUtils.getResourcePatternResolver((ResourceLoader)this.resourceLoader).getResources("classpath*:/META-INF/**/pom.xml")) {
            try {
                Model model = reader.read(res.getInputStream());
                String name = model.getArtifactId();
                String groupId = model.getGroupId();
                Parent parent = model.getParent();
                while (groupId == null && model.getParent() != null) {
                    groupId = parent.getGroupId();
                    parent = model.getParent();
                }
                String version = model.getVersion();
                Parent parent2 = model.getParent();
                while (version == null && model.getParent() != null) {
                    version = parent2.getVersion();
                    parent2 = model.getParent();
                }
                if (!modules.containsKey(groupId)) {
                    modules.put(groupId, new HashMap());
                }
                if (!((Map)modules.get(groupId)).containsKey(name)) {
                    HashMap map = Maps.newHashMap();
                    map.put("group", groupId);
                    map.put("name", name);
                    map.put("files", new ArrayList());
                    map.put("versions", new ArrayList());
                    ((Map)modules.get(groupId)).put(name, map);
                } else {
                    ((Map)((Map)modules.get(groupId)).get(name)).put("warning", "1");
                }
                ((List)((Map)((Map)modules.get(groupId)).get(name)).get("versions")).add(version);
                ((List)((Map)((Map)modules.get(groupId)).get(name)).get("files")).add(res.getURI().toString());
            }
            catch (Exception e) {
                log.error((Object)("Error evaluating pom: " + res.getURI()));
                log.debug((Object)"-- ERROR --", (Throwable)e);
            }
        }
        ArrayList list = Lists.newArrayList();
        for (Map.Entry e : modules.entrySet()) {
            for (Map.Entry e1 : ((Map)e.getValue()).entrySet()) {
                list.add(e1.getValue());
            }
        }
        Collections.sort(list, new Comparator<Map<String, Object>>(){

            @Override
            public int compare(Map<String, Object> o1, Map<String, Object> o2) {
                if (o1.get("group").equals(o2.get("group"))) {
                    return o1.get("name").toString().compareTo(o2.get("name").toString());
                }
                return o1.get("group").toString().compareTo(o2.get("group").toString());
            }
        });
        return list;
    }

    private Map<String, String> getSysInfo(RuntimeMXBean mxbean) {
        return mxbean.getSystemProperties();
    }

    private Map<String, String> getGeneralInfo(RuntimeMXBean mxbean) {
        LinkedHashMap genInfo = Maps.newLinkedHashMap();
        genInfo.put("Hostname", this.hostname);
        genInfo.put("Port", this.port);
        genInfo.put("Context", this.context);
        genInfo.put("Uptime", HumanTime.exactly((long)mxbean.getUptime()));
        genInfo.put("Start Time", DateUtils.calculate_ISO8601((long)mxbean.getStartTime()));
        return genInfo;
    }

    private Map<String, String> getJvmInfo(RuntimeMXBean mxbean) {
        LinkedHashMap jvmInfo = Maps.newLinkedHashMap();
        jvmInfo.put("JVM Name", mxbean.getVmName());
        jvmInfo.put("JVM Vendor", mxbean.getVmVendor());
        jvmInfo.put("JVM Version", mxbean.getVmVersion());
        jvmInfo.put("JVM Spec Name", mxbean.getSpecName());
        jvmInfo.put("JVM Spec Vendor", mxbean.getSpecVendor());
        jvmInfo.put("JVM Spec Version", mxbean.getSpecVersion());
        jvmInfo.put("Running JVM Name", mxbean.getName());
        jvmInfo.put("Management Spec Version", mxbean.getManagementSpecVersion());
        return jvmInfo;
    }

    private Map<String, String> getLibInfo(RuntimeMXBean mxbean) {
        LinkedHashMap libInfo = Maps.newLinkedHashMap();
        libInfo.put("Classpath", mxbean.getClassPath().replaceAll(":", " : "));
        libInfo.put("Boot ClassPath", mxbean.getBootClassPath().replaceAll(":", " : "));
        libInfo.put("Input arguments", mxbean.getInputArguments().toString());
        libInfo.put("Library Path", mxbean.getLibraryPath().replaceAll(":", " : "));
        return libInfo;
    }

    public String getHostname() {
        return this.hostname;
    }

    @Required
    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public String getPort() {
        return this.port;
    }

    @Required
    public void setPort(String port) {
        this.port = port;
    }

    public String getContext() {
        return this.context;
    }

    @Required
    public void setContext(String context) {
        this.context = context;
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }
}

