var module = angular.module('modalInfo', []);

module.directive('modalInfo', function(){
	return {
		restrict: 'E',
		templateUrl: '../resources/html/vocabularies/modalInfo.html',
		controller: function($scope, $http){
			$scope.showInfoModal = function() {
				if ($scope.selectedVocabularyIndex != null) {
					// show modal for editing info of existing vocabulary
					$scope.modalInfo.id = $scope.vocabularies[$scope.selectedVocabularyIndex].id;
					$scope.modalInfo.name = $scope.vocabularies[$scope.selectedVocabularyIndex].name;
					$scope.modalInfo.code = $scope.vocabularies[$scope.selectedVocabularyIndex].code;
					$scope.modalInfo.description = $scope.vocabularies[$scope.selectedVocabularyIndex].description;
				} else {
					// show modal for new vocabulary
					$scope.modalInfo.id = '';
					$scope.modalInfo.name = '';
					$scope.modalInfo.code = '';
					$scope.modalInfo.description = '';
					hidePermanotice();
				}
				$('#infoModal').modal();
			}
			
			$scope.editInfo = function() {
				showSpinner();
				if ($scope.selectedVocabularyIndex == null) {
					// new vocabulary
					$http.post('createVocabulary', 
								{"name" : $scope.modalInfo.name, 
								"code" : $scope.modalInfo.code, 
								"description" : $scope.modalInfo.description})
						.success(
							function(data) {
								show_notification("success", "Vocabulary created successfully!");
								$scope.vocabularies.push({
									"id" : data,
									"name" : $scope.modalInfo.name,
									"code" : $scope.modalInfo.code,
									"description" : $scope.modalInfo.description
								});
								hideSpinner();
								$scope.loadVocabularies();
							})
						.error(
							function() {
								show_notification("error", "Cannot edit info..");
								hideSpinner();
							});
				} else {
					// edit vocabulary
					$http.post('commitVocabularyInfo?vocabularyId=' + $scope.vocabularies[$scope.selectedVocabularyIndex].id, 
								{"name" : $scope.modalInfo.name, 
								"code" : $scope.modalInfo.code, 
								"description" : $scope.modalInfo.description})
						.success(
							function() {
								// update model
								$scope.vocabularies[$scope.selectedVocabularyIndex].id = $scope.modalInfo.id;
								$scope.vocabularies[$scope.selectedVocabularyIndex].name = $scope.modalInfo.name;
								$scope.vocabularies[$scope.selectedVocabularyIndex].code = $scope.modalInfo.code;
								$scope.vocabularies[$scope.selectedVocabularyIndex].description = $scope.modalInfo.description;
								show_notification("success", "Vocabulary information saved correctly!");
								hideSpinner();
								$scope.loadVocabularies();
							})
						.error(
							function() {
								show_notification("error", "Cannot edit info..");
								hideSpinner();
							});
				}
				// dismiss modal
				$('.modal').modal('hide');
			}
		},
		controllerAs: 'modalInfo'
	};
});