/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.functionality.modular.ui.vocabularies.controllers;

import eu.dnetlib.functionality.modular.ui.vocabularies.model.Term;
import eu.dnetlib.functionality.modular.ui.vocabularies.model.Vocabulary;
import eu.dnetlib.functionality.modular.ui.vocabularies.persistence.VocabularyDAO;
import eu.dnetlib.functionality.modular.ui.vocabularies.persistence.VocabularyException;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class VocabulariesController
extends VocabularyDAO {
    private static final Log log = LogFactory.getLog(VocabulariesController.class);
    @Resource(name="vocabularyDao")
    private VocabularyDAO dao;

    @Override
    @RequestMapping(value={"/ui/vocabularies.json"})
    @ResponseBody
    public List<Vocabulary> getVocabularies() throws VocabularyException {
        log.info((Object)"vocabularies.json");
        return this.dao.getVocabularies();
    }

    @Override
    @RequestMapping(value={"/ui/terms.json"})
    @ResponseBody
    public List<Term> getTerms(@RequestParam(value="vocabularyId", required=true) String vocabularyId) throws VocabularyException {
        log.info((Object)("terms.json?vocabularyId=" + vocabularyId));
        return this.dao.getTerms(vocabularyId);
    }

    @Override
    @RequestMapping(value={"/ui/commitVocabulary"}, method={RequestMethod.POST})
    @ResponseBody
    public void commitTerms(@RequestBody(required=true) List<Term> terms, @RequestParam(value="vocabularyId", required=true) String vocabularyId) throws VocabularyException {
        log.info((Object)("committing vocabulary id = " + vocabularyId));
        this.dao.commitTerms(terms, vocabularyId);
    }

    @Override
    @RequestMapping(value={"/ui/commitVocabularyInfo"}, method={RequestMethod.POST})
    @ResponseBody
    public void commitVocabularyInfo(@RequestBody(required=true) Vocabulary voc, @RequestParam(value="vocabularyId", required=true) String vocabularyId) throws VocabularyException {
        log.info((Object)("committing vocabulary info id = " + vocabularyId));
        this.dao.commitVocabularyInfo(voc, vocabularyId);
    }

    @Override
    @RequestMapping(value={"/ui/createVocabulary"}, method={RequestMethod.POST})
    @ResponseBody
    public String createVocabulary(@RequestBody(required=true) Vocabulary voc) throws VocabularyException {
        log.info((Object)"create vocabulary");
        String vocId = this.dao.createVocabulary(voc);
        return vocId;
    }

    @Override
    @RequestMapping(value={"/ui/dropVocabulary"}, method={RequestMethod.GET})
    @ResponseBody
    public void dropVocabulary(@RequestParam(value="vocabularyId", required=true) String vocabularyId) throws VocabularyException {
        log.info((Object)("delete vocabulary id=" + vocabularyId));
        this.dao.dropVocabulary(vocabularyId);
    }
}

