var module = angular.module('modalRelation', []);

module.directive('modalRelation', function(){
	return {
		restrict: 'E',
		templateUrl: '../resources/html/vocabularies/modalRelation.html',
		controller: function($scope) {
			$scope.showRelModal = function(term, rel) {
				$scope.selectedTermIndex = $scope.entries.indexOf(term);
				$scope.selectedRelIndex = $scope.entries[$scope.selectedTermIndex].relations.indexOf(rel);
				if (rel != null) {
					// edit existing synonym
					$scope.modalRel.refTerm = $scope.entries[$scope.selectedTermIndex].englishName;
					$scope.modalRel.code = $scope.entries[$scope.selectedTermIndex].relations[$scope.selectedRelIndex].code;
					$scope.modalRel.type = $scope.entries[$scope.selectedTermIndex].relations[$scope.selectedRelIndex].type;
				} else {
					// new synonym
					$scope.modalRel.refTerm = $scope.entries[$scope.selectedTermIndex].englishName;
					$scope.modalRel.code = '';
					$scope.modalRel.type = '';
				}
				$('#relModal').modal();
			};

			$scope.editRel = function() {
				if ($scope.selectedRelIndex == -1) {
					$scope.entries[$scope.selectedTermIndex].relations.push({
						"code" : $scope.modalRel.code,
						"type" : $scope.modalRel.type
					});
				} else {
					$scope.entries[$scope.selectedTermIndex].relations[$scope.selectedRelIndex].code = $scope.modalRel.code;
					$scope.entries[$scope.selectedTermIndex].relations[$scope.selectedRelIndex].type = $scope.modalRel.type;
				}
				// dismiss modal
				$('.modal').modal('hide');
				if ($scope.autocommit) {
					$scope.commit();
				} else {
					showPermanotice("Uncommitted changes!");
				}
			}
		},
		controllerAs: 'modalRelation'
	};
});