/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.workflows.nodes.blackboard;

import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.Engine;
import com.googlecode.sarasvati.NodeToken;
import com.googlecode.sarasvati.env.Env;
import eu.dnetlib.enabling.tools.blackboard.AbstractBlackboardJobListener;
import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BlackboardWorkflowJobListener
extends AbstractBlackboardJobListener {
    private static final Log log = LogFactory.getLog(BlackboardWorkflowJobListener.class);
    private Engine engine;
    private NodeToken token;

    protected void onDone(BlackboardJob job) {
        log.debug((Object)"Blackboard workflow node DONE");
        this.complete(job, Arc.DEFAULT_ARC);
    }

    public BlackboardWorkflowJobListener(Engine engine, NodeToken token) {
        this.engine = engine;
        this.token = token;
    }

    public final void processJob(BlackboardJob job) {
        this.token.getEnv().setTransientAttribute("blackboard:job", (Object)job);
        super.processJob(job);
    }

    protected final void onFailed(BlackboardJob job) {
        log.warn((Object)("Blackboard workflow node FAILED: " + job.getError()));
        this.token.getEnv().setAttribute("system:hasFailed", (Object)true);
        this.token.getEnv().setAttribute("system:error", job.getError());
        this.complete(job, "failed");
    }

    protected final void complete(BlackboardJob job, String arc) {
        Env env = this.token.getEnv();
        this.populateEnv(env, job.getParameters());
        this.engine.complete(this.token, arc);
        this.engine.executeQueuedArcTokens(this.token.getProcess());
    }

    protected void populateEnv(Env env, Map<String, String> responseParams) {
        for (Map.Entry<String, String> entry : responseParams.entrySet()) {
            env.setAttribute("blackboard:param:" + entry.getKey(), entry.getValue());
        }
    }

    protected void onOngoing(BlackboardJob job) {
        this.token.getEnv().setAttribute("blackboard:isOngoing", (Object)true);
    }

    public Engine getEngine() {
        return this.engine;
    }

    public void setEngine(Engine engine) {
        this.engine = engine;
    }

    public NodeToken getToken() {
        return this.token;
    }

    public void setToken(NodeToken token) {
        this.token = token;
    }
}

