/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.workflows.nodes.objectStore;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Required;

public class RetrieveMdStoreId
extends SimpleJobNode {
    private String metadataFormat;
    private String interpretation;
    private String providerId;
    @Resource
    private UniqueServiceLocator serviceLocator;

    @Override
    protected String execute(NodeToken token) throws Exception {
        String workflowQuery = "for $x in collection('/db/DRIVER/MetaWorkflowDSResources/MetaWorkflowDSResourceType') where($x//DATAPROVIDER/@id='%s') return  distinct-values($x//WORKFLOW/@id/string())";
        ISLookUpService isLookUpService = (ISLookUpService)this.serviceLocator.getService(ISLookUpService.class);
        List result = isLookUpService.quickSearchProfile(String.format(workflowQuery, this.providerId));
        if (result.size() == 0) {
            throw new RuntimeException("there is no mdStore Associated to the provider " + token.getEnv().getAttribute(this.getProviderId()));
        }
        HashSet workflowIds = Sets.newHashSet((Iterable)result);
        Set<String> metadataIds = this.getMdStores(isLookUpService, workflowIds);
        Gson g = new GsonBuilder().disableHtmlEscaping().create();
        token.getEnv().setAttribute("mdId", g.toJson(metadataIds));
        token.getEnv().setAttribute("mdFormat", this.getMetadataFormat());
        return Arc.DEFAULT_ARC;
    }

    private Set<String> getMdStores(ISLookUpService isLookUpService, Set<String> workflowsId) {
        try {
            String query = "//RESOURCE_PROFILE[.//RESOURCE_IDENTIFIER/@value='%s']//PARAM[./@category/string()='MDSTORE_ID']/text()";
            HashSet mdStores = Sets.newHashSet();
            if (workflowsId == null) {
                return null;
            }
            for (String workflowId : workflowsId) {
                List result = isLookUpService.quickSearchProfile(String.format(query, workflowId));
                HashSet metadataIds = Sets.newHashSet((Iterable)result);
                mdStores.addAll(this.getRightMetadataId(isLookUpService, Lists.newArrayList((Iterable)metadataIds)));
            }
            return mdStores;
        }
        catch (ISLookUpException e) {
            return null;
        }
    }

    private Set<String> getRightMetadataId(ISLookUpService isLookUpService, Iterable<String> ids) throws ISLookUpException {
        String query = "let $x:=//RESOURCE_PROFILE[.//RESOURCE_IDENTIFIER/@value='%s'] return concat($x//METADATA_FORMAT/text(), '::<<>>::', $x//METADATA_FORMAT_INTERPRETATION/text())";
        HashSet result = Sets.newHashSet();
        for (String id : ids) {
            String[] values;
            List results = isLookUpService.quickSearchProfile(String.format(query, id));
            if (results.size() <= 0 || !this.metadataFormat.equals((values = ((String)results.get(0)).split("::<<>>::"))[0].trim()) || !this.interpretation.equals(values[1].trim())) continue;
            result.add(id);
        }
        return result;
    }

    public String getInterpretation() {
        return this.interpretation;
    }

    @Required
    public void setInterpretation(String interpretation) {
        this.interpretation = interpretation;
    }

    public String getMetadataFormat() {
        return this.metadataFormat;
    }

    @Required
    public void setMetadataFormat(String metadataFormat) {
        this.metadataFormat = metadataFormat;
    }

    public String getProviderId() {
        return this.providerId;
    }

    public void setProviderId(String providerId) {
        this.providerId = providerId;
    }
}

