/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.workflows.nodes;

import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.googlecode.sarasvati.Engine;
import com.googlecode.sarasvati.NodeToken;
import com.googlecode.sarasvati.mem.MemNode;
import eu.dnetlib.conf.PropertyFetcher;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanNameAware;

public abstract class SarasvatiJobNode
extends MemNode
implements BeanNameAware {
    private static final Log log = LogFactory.getLog(SarasvatiJobNode.class);
    private String beanName;
    private String params;
    private String envParams;
    private String sysParams;
    @Resource(name="propertyFetcher")
    private PropertyFetcher propertyFetcher;

    public void execute(Engine engine, NodeToken token) {
        String prefix = "system:node:" + this.getName() + ":";
        for (Field field : ((Object)((Object)this)).getClass().getDeclaredFields()) {
            try {
                field.setAccessible(true);
                token.getEnv().setAttribute(prefix + field.getName(), "" + field.get((Object)this));
            }
            catch (Exception e) {
                log.warn((Object)("Error accessing value of field: " + field.getName()));
            }
        }
    }

    protected Map<String, String> parseJsonParameters(NodeToken token) {
        HashMap res = Maps.newHashMap();
        for (Map.Entry<?, ?> e : this.asMapEntries(this.getSysParams())) {
            String propertyName = e.getValue().toString();
            if (!this.getPropertyFetcher().getProps().containsKey(propertyName)) {
                log.warn((Object)("unable to find system property: '" + propertyName + "'"));
            }
            String propertyValue = this.getPropertyFetcher().getProperty(propertyName);
            res.put(e.getKey().toString(), propertyValue);
        }
        for (Map.Entry<?, ?> e : this.asMapEntries(this.getEnvParams())) {
            String param = e.getValue().toString();
            if (token.getEnv().hasAttribute(param)) {
                res.put(e.getKey().toString(), token.getEnv().getAttribute(param));
                continue;
            }
            res.put(e.getKey().toString(), token.getFullEnv().getAttribute(param));
        }
        for (Map.Entry<?, ?> e : this.asMapEntries(this.getParams())) {
            res.put(e.getKey().toString(), e.getValue().toString());
        }
        return res;
    }

    private Set<Map.Entry<?, ?>> asMapEntries(String s) {
        try {
            return this.isSet(s) ? ((Map)new Gson().fromJson(s, Map.class)).entrySet() : new HashSet();
        }
        catch (JsonSyntaxException e) {
            log.error((Object)String.format("invalid json: %s", s));
            throw e;
        }
    }

    private boolean isSet(String s) {
        return s != null && !s.isEmpty();
    }

    public String getBeanName() {
        return this.beanName;
    }

    public void setBeanName(String beanName) {
        this.beanName = beanName;
    }

    public PropertyFetcher getPropertyFetcher() {
        return this.propertyFetcher;
    }

    public String getParams() {
        return this.params;
    }

    public void setParams(String params) {
        this.params = params;
    }

    public String getEnvParams() {
        return this.envParams;
    }

    public void setEnvParams(String envParams) {
        this.envParams = envParams;
    }

    public String getSysParams() {
        return this.sysParams;
    }

    public void setSysParams(String sysParams) {
        this.sysParams = sysParams;
    }
}

