/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.workflows.resultset;

import com.googlecode.sarasvati.GraphProcess;
import eu.dnetlib.enabling.resultset.ResultSetFactory;
import eu.dnetlib.enabling.resultset.client.utils.EPRUtils;
import eu.dnetlib.enabling.resultset.rmi.ResultSetException;
import eu.dnetlib.enabling.resultset.rmi.ResultSetService;
import eu.dnetlib.enabling.tools.ServiceResolver;
import eu.dnetlib.msro.workflows.resultset.ProcessCountingResultSetListener;
import eu.dnetlib.msro.workflows.util.ResultsetProgressProvider;
import javax.xml.ws.wsaddressing.W3CEndpointReference;
import org.springframework.beans.factory.annotation.Required;

public class ProcessCountingResultSetFactory {
    private ResultSetFactory resultSetFactory;
    private ServiceResolver serviceResolver;

    public ResultsetProgressProvider createProgressProvider(GraphProcess process, String epr) throws ResultSetException {
        return this.createProgressProvider(process, new EPRUtils().getEpr(epr));
    }

    public ResultsetProgressProvider createProgressProvider(GraphProcess process, W3CEndpointReference epr) throws ResultSetException {
        ResultSetService service = (ResultSetService)this.serviceResolver.getService(ResultSetService.class, epr);
        String rsId = this.serviceResolver.getResourceIdentifier(epr);
        return new ResultsetProgressProvider(this.resultSetFactory, new ProcessCountingResultSetListener(process, service, rsId));
    }

    public ResultSetFactory getResultSetFactory() {
        return this.resultSetFactory;
    }

    @Required
    public void setResultSetFactory(ResultSetFactory resultSetFactory) {
        this.resultSetFactory = resultSetFactory;
    }

    public ServiceResolver getServiceResolver() {
        return this.serviceResolver;
    }

    @Required
    public void setServiceResolver(ServiceResolver serviceResolver) {
        this.serviceResolver = serviceResolver;
    }
}

