/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.workflows.nodes.info;

import com.google.common.collect.Maps;
import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.enabling.datasources.rmi.DatasourceManagerService;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import org.dom4j.Document;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;

public class ObjectStoreToApiExtraFieldJobNode
extends SimpleJobNode {
    private String objId;
    private String datasourceId;
    private String datasourceInterface;
    private String extraFieldForTotal;
    private String extraFieldForDate;
    private String extraFieldForObjId;
    @Resource
    private UniqueServiceLocator serviceLocator;

    @Override
    protected String execute(NodeToken token) throws Exception {
        String xq = "for $x in collection('/db/DRIVER/ObjectStoreDSResources/ObjectStoreDSResourceType') where $x//RESOURCE_IDENTIFIER/@value='" + this.objId + "' return concat($x//COUNT_STORE, ' @=@ ', $x//LAST_STORAGE_DATE)";
        String s = ((ISLookUpService)this.serviceLocator.getService(ISLookUpService.class)).getResourceProfileByQuery(xq);
        String[] arr = s.split(" @=@ ");
        Map<String, String> map = this.getCurrentExtraFields(this.datasourceId, this.datasourceInterface);
        map.put(this.extraFieldForTotal, arr[0].trim());
        map.put(this.extraFieldForDate, arr[1].trim());
        map.put(this.extraFieldForObjId, this.objId);
        ((DatasourceManagerService)this.serviceLocator.getService(DatasourceManagerService.class)).bulkUpdateApiExtraFields(this.datasourceId, this.datasourceInterface, map);
        return Arc.DEFAULT_ARC;
    }

    private Map<String, String> getCurrentExtraFields(String repoId, String ifaceId) throws Exception {
        HashMap res = Maps.newHashMap();
        SAXReader reader = new SAXReader();
        String profile = ((ISLookUpService)this.serviceLocator.getService(ISLookUpService.class)).getResourceProfile(repoId);
        Document doc = reader.read((Reader)new StringReader(profile));
        Node ifcNode = doc.selectSingleNode("//INTERFACE[@id='" + ifaceId + "']");
        if (ifcNode != null) {
            for (Object o : ifcNode.selectNodes("./INTERFACE_EXTRA_FIELD")) {
                res.put(((Node)o).valueOf("@name"), ((Node)o).getText());
            }
        }
        return res;
    }

    public String getDatasourceId() {
        return this.datasourceId;
    }

    public void setDatasourceId(String datasourceId) {
        this.datasourceId = datasourceId;
    }

    public String getDatasourceInterface() {
        return this.datasourceInterface;
    }

    public void setDatasourceInterface(String datasourceInterface) {
        this.datasourceInterface = datasourceInterface;
    }

    public String getExtraFieldForTotal() {
        return this.extraFieldForTotal;
    }

    public void setExtraFieldForTotal(String extraFieldForTotal) {
        this.extraFieldForTotal = extraFieldForTotal;
    }

    public String getExtraFieldForDate() {
        return this.extraFieldForDate;
    }

    public void setExtraFieldForDate(String extraFieldForDate) {
        this.extraFieldForDate = extraFieldForDate;
    }

    public String getObjId() {
        return this.objId;
    }

    public void setObjId(String objId) {
        this.objId = objId;
    }

    public String getExtraFieldForObjId() {
        return this.extraFieldForObjId;
    }

    public void setExtraFieldForObjId(String extraFieldForObjId) {
        this.extraFieldForObjId = extraFieldForObjId;
    }
}

