/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.workflows.nodes.unpack;

import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.enabling.resultset.IterableResultSetFactory;
import eu.dnetlib.enabling.resultset.client.ResultSetClientFactory;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import java.io.Reader;
import java.io.StringReader;
import java.util.Iterator;
import java.util.Queue;
import java.util.concurrent.PriorityBlockingQueue;
import javax.xml.ws.wsaddressing.W3CEndpointReference;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;
import org.springframework.beans.factory.annotation.Required;

public class UnpackJobNode
extends SimpleJobNode {
    private static final Log log = LogFactory.getLog(UnpackJobNode.class);
    private String inputEprParam;
    private String outputEprParam;
    private String xpath;
    private IterableResultSetFactory iterableResultSetFactory;
    private ResultSetClientFactory resultSetClientFactory;

    @Override
    protected String execute(NodeToken token) throws Exception {
        final Iterator client = this.resultSetClientFactory.getClient(token.getEnv().getAttribute(this.inputEprParam)).iterator();
        final PriorityBlockingQueue<String> queue = new PriorityBlockingQueue<String>();
        while (queue.isEmpty() && client.hasNext()) {
            this.populateQueue(queue, (String)client.next(), this.xpath);
        }
        W3CEndpointReference epr = this.iterableResultSetFactory.createIterableResultSet((Iterable)new Iterable<String>(){

            @Override
            public Iterator<String> iterator() {
                return new Iterator<String>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public boolean hasNext() {
                        Queue queue = queue;
                        synchronized (queue) {
                            return !queue.isEmpty();
                        }
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public String next() {
                        Queue queue = queue;
                        synchronized (queue) {
                            String res = (String)queue.poll();
                            while (queue.isEmpty() && client.hasNext()) {
                                UnpackJobNode.this.populateQueue(queue, (String)client.next(), UnpackJobNode.this.xpath);
                            }
                            return res;
                        }
                    }

                    @Override
                    public void remove() {
                    }
                };
            }
        });
        token.getEnv().setAttribute(this.outputEprParam, epr.toString());
        return Arc.DEFAULT_ARC;
    }

    private void populateQueue(Queue<String> queue, String record, String xpath) {
        try {
            SAXReader reader = new SAXReader();
            Document doc = reader.read((Reader)new StringReader(record));
            for (Object o : doc.selectNodes(xpath)) {
                queue.add(((Node)o).asXML());
            }
        }
        catch (Exception e) {
            log.error((Object)("Error unpacking record: \n" + record), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public IterableResultSetFactory getIterableResultSetFactory() {
        return this.iterableResultSetFactory;
    }

    @Required
    public void setIterableResultSetFactory(IterableResultSetFactory iterableResultSetFactory) {
        this.iterableResultSetFactory = iterableResultSetFactory;
    }

    public ResultSetClientFactory getResultSetClientFactory() {
        return this.resultSetClientFactory;
    }

    @Required
    public void setResultSetClientFactory(ResultSetClientFactory resultSetClientFactory) {
        this.resultSetClientFactory = resultSetClientFactory;
    }

    public String getInputEprParam() {
        return this.inputEprParam;
    }

    public void setInputEprParam(String inputEprParam) {
        this.inputEprParam = inputEprParam;
    }

    public String getOutputEprParam() {
        return this.outputEprParam;
    }

    public void setOutputEprParam(String outputEprParam) {
        this.outputEprParam = outputEprParam;
    }

    public String getXpath() {
        return this.xpath;
    }

    public void setXpath(String xpath) {
        this.xpath = xpath;
    }
}

