/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.workflows.nodes.db;

import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.enabling.database.rmi.DatabaseService;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.msro.workflows.nodes.AsyncJobNode;
import java.io.IOException;
import java.io.InputStream;
import javax.annotation.Resource;
import javax.xml.ws.wsaddressing.W3CEndpointReference;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;

public class QueryDbJobNode
extends AsyncJobNode {
    private String db;
    private String dbParam;
    private String dbProperty;
    private String sql;
    private String sqlForSize;
    private String xslt;
    private String outputEprParam;
    @Resource
    private UniqueServiceLocator serviceLocator;

    @Override
    protected String execute(NodeToken token) throws Exception {
        String sqlText = this.fetchSqlAsText(this.sql);
        W3CEndpointReference epr = null;
        DatabaseService dbService = (DatabaseService)this.serviceLocator.getService(DatabaseService.class);
        if (StringUtils.isNotBlank((String)this.xslt)) {
            String xsltText = IOUtils.toString((InputStream)((Object)((Object)this)).getClass().getResourceAsStream(this.xslt));
            epr = StringUtils.isBlank((String)this.sqlForSize) ? dbService.xsltSearchSQL(this.findDb(token), sqlText, xsltText) : dbService.alternativeXsltSearchSQL(this.findDb(token), sqlText, this.fetchSqlAsText(this.sqlForSize), xsltText);
        } else {
            epr = StringUtils.isBlank((String)this.sqlForSize) ? dbService.searchSQL(this.findDb(token), sqlText) : dbService.alternativeSearchSQL(this.findDb(token), sqlText, this.fetchSqlAsText(this.sqlForSize));
        }
        token.getEnv().setAttribute(this.outputEprParam, epr.toString());
        return Arc.DEFAULT_ARC;
    }

    private String fetchSqlAsText(String path) throws IOException {
        return IOUtils.toString((InputStream)((Object)((Object)this)).getClass().getResourceAsStream(path));
    }

    private String findDb(NodeToken token) {
        if (this.dbParam != null && !this.dbParam.isEmpty()) {
            return token.getEnv().getAttribute(this.dbParam);
        }
        if (this.dbProperty != null && !this.dbProperty.isEmpty()) {
            return this.getPropertyFetcher().getProperty(this.dbProperty);
        }
        return this.db;
    }

    public String getDb() {
        return this.db;
    }

    public void setDb(String db) {
        this.db = db;
    }

    public String getDbParam() {
        return this.dbParam;
    }

    public void setDbParam(String dbParam) {
        this.dbParam = dbParam;
    }

    public String getSql() {
        return this.sql;
    }

    public void setSql(String sql) {
        this.sql = sql;
    }

    public String getXslt() {
        return this.xslt;
    }

    public void setXslt(String xslt) {
        this.xslt = xslt;
    }

    public String getOutputEprParam() {
        return this.outputEprParam;
    }

    public void setOutputEprParam(String outputEprParam) {
        this.outputEprParam = outputEprParam;
    }

    public String getDbProperty() {
        return this.dbProperty;
    }

    public void setDbProperty(String dbProperty) {
        this.dbProperty = dbProperty;
    }

    public String getSqlForSize() {
        return this.sqlForSize;
    }

    public void setSqlForSize(String sqlForSize) {
        this.sqlForSize = sqlForSize;
    }
}

