/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.workflows.nodes.db;

import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.enabling.database.rmi.DatabaseService;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.msro.workflows.nodes.AsyncJobNode;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;

public class ExecuteSqlFromEnvJobNode
extends AsyncJobNode {
    private String db;
    private String dbParam;
    private String dbProperty;
    private String sqlParamName;
    @Resource
    private UniqueServiceLocator serviceLocator;

    @Override
    protected String execute(NodeToken token) throws Exception {
        String sql = token.getEnv().getAttribute(this.sqlParamName);
        if (StringUtils.isBlank((String)sql)) {
            throw new IllegalArgumentException("Missing value in env attribute named: " + this.sqlParamName);
        }
        ((DatabaseService)this.serviceLocator.getService(DatabaseService.class)).updateSQL(this.findDb(token), sql);
        return Arc.DEFAULT_ARC;
    }

    private String findDb(NodeToken token) {
        if (this.dbParam != null && !this.dbParam.isEmpty()) {
            return token.getEnv().getAttribute(this.dbParam);
        }
        if (this.dbProperty != null && !this.dbProperty.isEmpty()) {
            return this.getPropertyFetcher().getProperty(this.dbProperty);
        }
        return this.db;
    }

    public String getDb() {
        return this.db;
    }

    public void setDb(String db) {
        this.db = db;
    }

    public String getDbParam() {
        return this.dbParam;
    }

    public void setDbParam(String dbParam) {
        this.dbParam = dbParam;
    }

    public String getDbProperty() {
        return this.dbProperty;
    }

    public void setDbProperty(String dbProperty) {
        this.dbProperty = dbProperty;
    }

    public String getSqlParamName() {
        return this.sqlParamName;
    }

    public void setSqlParamName(String sqlParamName) {
        this.sqlParamName = sqlParamName;
    }
}

