/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.workflows.nodes.mdstore;

import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.data.mdstore.MDStoreService;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.msro.rmi.MSROException;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import javax.annotation.Resource;
import javax.xml.ws.wsaddressing.W3CEndpointReference;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FetchMDStoreRecordsJobNode
extends SimpleJobNode {
    private static final Log log = LogFactory.getLog(FetchMDStoreRecordsJobNode.class);
    @Resource
    private UniqueServiceLocator serviceLocator;
    private String mdId;
    @Deprecated
    private String mdFormat;
    private String eprParam;

    @Override
    protected String execute(NodeToken token) throws Exception {
        Long dateFromFilter;
        if (this.getMdId() == null) {
            this.setMdId(token.getEnv().getAttribute("mdId"));
        }
        if (this.getMdFormat() == null) {
            this.setMdFormat(token.getEnv().getAttribute("mdFormat"));
        }
        if ((dateFromFilter = (Long)token.getFullEnv().getAttribute("DateFromFilter", Long.class)) != null) {
            log.info((Object)("From Filter activated, from: " + dateFromFilter));
        }
        MDStoreService mdStoreService = (MDStoreService)this.serviceLocator.getService(MDStoreService.class, this.getMdId());
        int size = mdStoreService.size(this.getMdId());
        token.getEnv().setAttribute("mainlog:sourceSize", (Object)size);
        log.info((Object)String.format("getting MDRecords from: %s, sourceSize: %s", this.getMdId(), size));
        String from = dateFromFilter != null ? "" + dateFromFilter : "";
        W3CEndpointReference epr = mdStoreService.deliverMDRecords(this.getMdId(), from, "", "");
        if (epr == null) {
            throw new MSROException("unable to read MDRecords from: " + this.getMdId());
        }
        token.getEnv().setAttribute(this.getEprParam(), epr.toString());
        return Arc.DEFAULT_ARC;
    }

    public String getMdId() {
        return this.mdId;
    }

    public void setMdId(String mdId) {
        this.mdId = mdId;
    }

    @Deprecated
    public String getMdFormat() {
        return this.mdFormat;
    }

    @Deprecated
    public void setMdFormat(String mdFormat) {
        this.mdFormat = mdFormat;
    }

    public String getEprParam() {
        return this.eprParam;
    }

    public void setEprParam(String eprParam) {
        this.eprParam = eprParam;
    }
}

