/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.workflows.nodes.collect;

import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.common.logging.DnetLogger;
import eu.dnetlib.msro.rmi.MSROException;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FindDateRangeForIncrementalHarvestingJobNode
extends SimpleJobNode {
    private String fromDateParam;
    private String untilDateParam;
    private long ONE_DAY = 86400000L;
    @Resource(name="msroWorkflowLogger")
    private DnetLogger dnetLogger;
    private static final Log log = LogFactory.getLog(FindDateRangeForIncrementalHarvestingJobNode.class);

    @Override
    protected String execute(NodeToken token) throws Exception {
        String profId = this.findCurrentWfProfileId(token);
        String fromDate = this.calculateFromDate(profId);
        String untilDate = null;
        log.info((Object)("Incremental Harv Details - profId: " + profId + " - from: " + fromDate + " - until: " + untilDate));
        if (fromDate != null) {
            token.getEnv().setAttribute(this.getFromDateParam(), fromDate);
        }
        return Arc.DEFAULT_ARC;
    }

    private String calculateFromDate(String profId) {
        long d = this.findLastSuccessStartDate(profId);
        return d > 0L ? new SimpleDateFormat("yyyy-MM-dd").format(new Date(d - this.ONE_DAY)) : null;
    }

    private long findLastSuccessStartDate(String profId) {
        long res = -1L;
        Iterator iter = this.dnetLogger.find("system:profileId", profId);
        while (iter.hasNext()) {
            long curr;
            Map map = (Map)iter.next();
            if (!"true".equalsIgnoreCase((String)map.get("system:isCompletedSuccessfully")) || (curr = NumberUtils.toLong((String)((String)map.get("system:startDate")), (long)-1L)) <= res) continue;
            res = curr;
        }
        return res;
    }

    private String findCurrentWfProfileId(NodeToken token) throws MSROException {
        String p1 = token.getEnv().getAttribute("system:profileId");
        if (p1 != null && !p1.isEmpty()) {
            return p1;
        }
        String p2 = token.getFullEnv().getAttribute("system:profileId");
        if (p2 != null && !p2.isEmpty()) {
            return p2;
        }
        String p3 = token.getProcess().getEnv().getAttribute("system:profileId");
        if (p3 != null && !p3.isEmpty()) {
            return p3;
        }
        throw new MSROException("Missing property in env: system:profileId");
    }

    public String getFromDateParam() {
        return this.fromDateParam;
    }

    public void setFromDateParam(String fromDateParam) {
        this.fromDateParam = fromDateParam;
    }

    public String getUntilDateParam() {
        return this.untilDateParam;
    }

    public void setUntilDateParam(String untilDateParam) {
        this.untilDateParam = untilDateParam;
    }
}

