/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.workflows.metawf;

import eu.dnetlib.enabling.is.registry.rmi.ISRegistryException;
import eu.dnetlib.enabling.is.registry.rmi.ISRegistryService;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.msro.workflows.metawf.WorkflowProfileCreator;
import eu.dnetlib.msro.workflows.metawf.WorkflowStartModeEnum;
import java.io.IOException;
import java.io.StringWriter;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang.StringEscapeUtils;
import org.springframework.beans.factory.annotation.Required;

public class WorkflowTree {
    private String id;
    private String name;
    private WorkflowStartModeEnum start = WorkflowStartModeEnum.auto;
    private List<WorkflowTree> children;
    private org.springframework.core.io.Resource template;
    @Resource
    private UniqueServiceLocator serviceLocator;

    public void populateMetaWfXml(StringWriter sw) {
        sw.append("<WORKFLOW id='" + StringEscapeUtils.escapeXml((String)this.id) + "' name='" + StringEscapeUtils.escapeXml((String)this.name) + "'");
        if (this.children == null || this.children.isEmpty()) {
            sw.append(" />");
        } else {
            sw.append(">");
            for (WorkflowTree child : this.children) {
                child.populateMetaWfXml(sw);
            }
            sw.append("</WORKFLOW>");
        }
    }

    public int registerAllWorkflows(Map<String, String> params) throws ISRegistryException, IOException {
        int count = 0;
        if (this.id == null || this.id.isEmpty()) {
            String profile = WorkflowProfileCreator.generateProfile(this.name, "aggregator", this.start, params, this.template);
            this.id = ((ISRegistryService)this.serviceLocator.getService(ISRegistryService.class)).registerProfile(profile);
            ++count;
        }
        if (this.children != null) {
            for (WorkflowTree child : this.children) {
                count += child.registerAllWorkflows(params);
            }
        }
        return count;
    }

    public String getId() {
        return this.id;
    }

    public List<WorkflowTree> getChildren() {
        return this.children;
    }

    public void setChildren(List<WorkflowTree> children) {
        this.children = children;
    }

    public String getName() {
        return this.name;
    }

    @Required
    public void setName(String name) {
        this.name = name;
    }

    public org.springframework.core.io.Resource getTemplate() {
        return this.template;
    }

    @Required
    public void setTemplate(org.springframework.core.io.Resource template) {
        this.template = template;
    }

    public WorkflowStartModeEnum getStart() {
        return this.start;
    }

    public void setStart(WorkflowStartModeEnum start) {
        this.start = start;
    }
}

