/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.workflows.nodes.collect;

import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.data.collector.rmi.CollectorService;
import eu.dnetlib.data.collector.rmi.InterfaceDescriptor;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.msro.rmi.MSROException;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import javax.xml.ws.wsaddressing.W3CEndpointReference;
import org.dom4j.Document;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;

public class CollectRecordsJobNode
extends SimpleJobNode {
    @Resource
    private UniqueServiceLocator serviceLocator;
    private String datasourceId;
    private String datasourceInterface;
    private String eprParam;

    @Override
    protected String execute(NodeToken token) throws Exception {
        String profile = ((ISLookUpService)this.serviceLocator.getService(ISLookUpService.class)).getResourceProfile(this.datasourceId);
        Document doc = new SAXReader().read((Reader)new StringReader(profile));
        Node ifcNode = doc.selectSingleNode("//INTERFACE[@id='" + this.datasourceInterface + "']");
        InterfaceDescriptor interfaceDescriptor = InterfaceDescriptor.newInstance((Node)ifcNode);
        if (interfaceDescriptor == null) {
            throw new MSROException("invalid interface descriptor: " + this.datasourceInterface);
        }
        W3CEndpointReference epr = ((CollectorService)this.serviceLocator.getService(CollectorService.class)).collect(interfaceDescriptor);
        token.getEnv().setAttribute(this.getEprParam(), epr.toString());
        token.getEnv().setAttribute("dataprovider:interface:baseUrl", interfaceDescriptor.getBaseUrl());
        token.getEnv().setAttribute("dataprovider:protocol", interfaceDescriptor.getProtocol());
        HashMap params = interfaceDescriptor.getParams();
        if (params != null) {
            for (Map.Entry e : params.entrySet()) {
                token.getEnv().setAttribute("dataprovider:" + (String)e.getKey(), (String)e.getValue());
            }
        }
        return Arc.DEFAULT_ARC;
    }

    public String getDatasourceId() {
        return this.datasourceId;
    }

    public void setDatasourceId(String datasourceId) {
        this.datasourceId = datasourceId;
    }

    public String getDatasourceInterface() {
        return this.datasourceInterface;
    }

    public void setDatasourceInterface(String datasourceInterface) {
        this.datasourceInterface = datasourceInterface;
    }

    public String getEprParam() {
        return this.eprParam;
    }

    public void setEprParam(String eprParam) {
        this.eprParam = eprParam;
    }
}

