/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.workflows.util;

import com.googlecode.sarasvati.GraphProcess;
import com.googlecode.sarasvati.NodeToken;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ProcessUtils {
    private static String oldGeneratedId = "";
    private static final Log log = LogFactory.getLog(ProcessUtils.class);

    public static String calculateName(GraphProcess process) {
        return process.getGraph().getName();
    }

    public static String calculateFamily(GraphProcess process) {
        return process.getEnv().getAttribute("system:profileFamily");
    }

    public static String calculateWfId(GraphProcess process) {
        return process.getEnv().getAttribute("system:profileId");
    }

    public static String calculateStatus(GraphProcess process) {
        if (!process.isComplete()) {
            return process.getState().toString().toUpperCase();
        }
        if ("true".equals(process.getEnv().getAttribute("system:isCompletedSuccessfully"))) {
            return "SUCCESS";
        }
        return "FAILURE";
    }

    public static Date calculateLastActivityDate(GraphProcess process) {
        Date date = null;
        for (NodeToken token : process.getNodeTokens()) {
            Date activity = token.getCompleteDate();
            if (activity == null) {
                activity = token.getCreateDate();
            }
            if (date == null) {
                date = activity;
            }
            if (activity == null || date == null || activity.compareTo(date) <= 0) continue;
            date = activity;
        }
        return date;
    }

    public static String calculateRepo(GraphProcess process) {
        if (process.getEnv().hasAttribute("dataprovider:name")) {
            return process.getEnv().getAttribute("dataprovider:name");
        }
        return "";
    }

    public static String calculateRepoId(GraphProcess process) {
        if (process.getEnv().hasAttribute("dataprovider:originalid")) {
            return process.getEnv().getAttribute("dataprovider:originalid");
        }
        return "";
    }

    public static String calculateApiId(GraphProcess process) {
        if (process.getEnv().hasAttribute("dataprovider:interface")) {
            return process.getEnv().getAttribute("dataprovider:interface");
        }
        return "";
    }

    public static synchronized String generateProcessId() {
        String id = "";
        do {
            id = "wf_" + new SimpleDateFormat("yyyyMMdd_HHmmss_S").format(new Date());
            log.info((Object)("Generated processID " + id));
        } while (id.equals(oldGeneratedId));
        oldGeneratedId = id;
        return id;
    }
}

