package eu.dnetlib.msro.workflows.nodes.collect;

import java.util.Map;

import javax.xml.ws.wsaddressing.W3CEndpointReference;

import org.springframework.beans.factory.annotation.Autowired;

import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.NodeToken;

import eu.dnetlib.data.collector.rmi.CollectorService;
import eu.dnetlib.data.collector.rmi.InterfaceDescriptor;
import eu.dnetlib.enabling.datasources.common.Api;
import eu.dnetlib.enabling.datasources.common.ApiParam;
import eu.dnetlib.enabling.datasources.common.Datasource;
import eu.dnetlib.enabling.datasources.common.LocalDatasourceManager;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.msro.rmi.MSROException;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import eu.dnetlib.msro.workflows.util.WorkflowsConstants;

public class CollectRecordsJobNode extends SimpleJobNode {

	@Autowired
	private UniqueServiceLocator serviceLocator;

	@Autowired
	private LocalDatasourceManager<Datasource<?, ?, ?>, Api<ApiParam>> dsManager;

	private String datasourceId;
	private String datasourceInterface;
	private String eprParam;

	@Override
	protected String execute(final NodeToken token) throws Exception {

		final Api<ApiParam> api = dsManager.getApis(datasourceId)
			.stream()
			.filter(a -> a.getId().equals(datasourceInterface))
			.findFirst()
			.orElseThrow(() -> new MSROException("Api not found"));

		final InterfaceDescriptor interfaceDescriptor = new InterfaceDescriptor();
		interfaceDescriptor.setBaseUrl(api.getBaseurl());
		interfaceDescriptor.setId(datasourceInterface);
		interfaceDescriptor.setProtocol(api.getProtocol());
		api.getApiParams().forEach(p -> interfaceDescriptor.getParams().put(p.getParam(), p.getValue()));

		final W3CEndpointReference epr = serviceLocator.getService(CollectorService.class).collect(interfaceDescriptor);

		token.getEnv().setAttribute(getEprParam(), epr.toString());

		token.getEnv().setAttribute(WorkflowsConstants.DATAPROVIDER_INTERFACE_BASEURL, interfaceDescriptor.getBaseUrl());
		token.getEnv().setAttribute(WorkflowsConstants.DATAPROVIDER_PREFIX + "protocol", interfaceDescriptor.getProtocol());
		final Map<String, String> params = interfaceDescriptor.getParams();
		if (params != null) {
			for (final Map.Entry<String, String> e : params.entrySet()) {
				token.getEnv().setAttribute(WorkflowsConstants.DATAPROVIDER_PREFIX + e.getKey(), e.getValue());
			}
		}

		return Arc.DEFAULT_ARC;
	}

	public String getDatasourceId() {
		return datasourceId;
	}

	public void setDatasourceId(final String datasourceId) {
		this.datasourceId = datasourceId;
	}

	public String getDatasourceInterface() {
		return datasourceInterface;
	}

	public void setDatasourceInterface(final String datasourceInterface) {
		this.datasourceInterface = datasourceInterface;
	}

	public String getEprParam() {
		return eprParam;
	}

	public void setEprParam(final String eprParam) {
		this.eprParam = eprParam;
	}

}
