/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.workflows.metawf;

import com.google.common.base.Function;
import com.google.common.collect.Maps;
import eu.dnetlib.msro.workflows.metawf.WorkflowStartModeEnum;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.antlr.stringtemplate.StringTemplate;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;

public class WorkflowProfileCreator {
    private static final Resource wfTemplate = new ClassPathResource("/eu/dnetlib/msro/workflows/templates/workflow.xml.st");

    public static String generateProfile(String name, String type, WorkflowStartModeEnum startMode, Map<String, String> params, Resource confTemplate) throws IOException {
        StringTemplate conf = new StringTemplate(IOUtils.toString((InputStream)confTemplate.getInputStream()));
        conf.setAttribute("params", (Object)Maps.transformValues(params, (Function)new Function<String, String>(){

            public String apply(String s) {
                return StringEscapeUtils.escapeXml((String)s);
            }
        }));
        StringTemplate profile = new StringTemplate(IOUtils.toString((InputStream)wfTemplate.getInputStream()));
        profile.setAttribute("name", (Object)name);
        profile.setAttribute("type", (Object)type);
        profile.setAttribute("priority", 50);
        profile.setAttribute("conf", (Object)conf.toString());
        profile.setAttribute("startMode", (Object)startMode);
        return profile.toString();
    }
}

