/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.workflows.nodes;

import com.googlecode.sarasvati.Engine;
import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.msro.workflows.nodes.SarasvatiJobNode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class SimpleJobNode
extends SarasvatiJobNode {
    private static final Log log = LogFactory.getLog(SarasvatiJobNode.class);

    @Override
    public final void execute(Engine engine, NodeToken token) {
        super.execute(engine, token);
        try {
            log.debug((Object)("START NODE: " + this.getBeanName()));
            this.beforeStart(token);
            String arc = this.execute(token);
            this.beforeCompleted(token);
            log.debug((Object)("END NODE (SUCCESS): " + this.getBeanName()));
            engine.complete(token, arc);
        }
        catch (Throwable e) {
            log.error((Object)"got exception while executing workflow node", e);
            log.debug((Object)("END NODE (FAILED): " + this.getBeanName()));
            this.beforeFailed(token);
            token.getEnv().setAttribute("system:hasFailed", (Object)true);
            token.getEnv().setAttribute("system:error", e.getMessage());
            engine.complete(token, "failed");
        }
    }

    protected abstract String execute(NodeToken var1) throws Exception;

    protected void beforeStart(NodeToken token) {
    }

    protected void beforeCompleted(NodeToken token) {
    }

    protected void beforeFailed(NodeToken token) {
    }
}

