/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.workflows.nodes.repobye;

import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.enabling.datasources.common.Api;
import eu.dnetlib.enabling.datasources.common.Datasource;
import eu.dnetlib.enabling.datasources.common.LocalDatasourceManager;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.is.registry.rmi.ISRegistryService;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;
import org.springframework.beans.factory.annotation.Autowired;

public class DeleteMetaWfJobNode
extends SimpleJobNode {
    private String metaWfId;
    @Autowired
    private UniqueServiceLocator serviceLocator;
    @Autowired
    private LocalDatasourceManager<Datasource<?, ?, ?>, Api<?>> dsManager;
    private static final Log log = LogFactory.getLog(DeleteMetaWfJobNode.class);

    @Override
    protected String execute(NodeToken token) throws Exception {
        String profile = ((ISLookUpService)this.serviceLocator.getService(ISLookUpService.class)).getResourceProfile(this.metaWfId);
        Document doc = new SAXReader().read((Reader)new StringReader(profile));
        String dsId = doc.valueOf("//DATAPROVIDER/@id");
        String dsName = doc.valueOf("//DATAPROVIDER/text()");
        String ifaceId = doc.valueOf("//DATAPROVIDER/@interface");
        String destroyWfId = doc.valueOf("//CONFIGURATION/@destroyWorkflow");
        log.info((Object)("Removing a MetaWf of dataprovider: " + dsId));
        token.getEnv().setAttribute("dataprovider:id", dsId);
        token.getEnv().setAttribute("dataprovider:name", dsName);
        token.getEnv().setAttribute("dataprovider:interface", ifaceId);
        ISRegistryService registry = (ISRegistryService)this.serviceLocator.getService(ISRegistryService.class);
        for (Object o : doc.selectNodes("//WORKFLOW")) {
            String wfId = ((Node)o).valueOf("@id");
            try {
                registry.deleteProfile(wfId);
                log.info((Object)(" - Deleted Workflow: " + wfId));
            }
            catch (Exception e) {
                log.error((Object)(" - (ERR) Error deleting profile " + wfId));
            }
        }
        registry.deleteProfile(this.metaWfId);
        log.info((Object)(" - Deleted MetaWorkflow: " + this.metaWfId));
        registry.deleteProfile(destroyWfId);
        log.info((Object)(" - Deleted destroy workflow: " + destroyWfId));
        this.verifyDatasource(dsId, ifaceId);
        return Arc.DEFAULT_ARC;
    }

    private void verifyDatasource(String dsId, String ifaceId) throws Exception {
        StringWriter sw = new StringWriter();
        sw.append("for $x in collection('/db/DRIVER/MetaWorkflowDSResources/MetaWorkflowDSResourceType') where");
        sw.append("  $x//DATAPROVIDER/@id = '" + dsId + "' and ");
        sw.append("  $x//DATAPROVIDER/@interface = '" + ifaceId + "' and ");
        sw.append("  $x//RESOURCE_IDENTIFIER/@value != '" + this.metaWfId + "' ");
        sw.append("return $x//RESOURCE_IDENTIFIER/@value/string()");
        boolean active = !((ISLookUpService)this.serviceLocator.getService(ISLookUpService.class)).quickSearchProfile(sw.toString()).isEmpty();
        log.info((Object)(" - Updating iface, active status: " + active));
        this.setActivationStatus(dsId, ifaceId, active);
    }

    protected void setActivationStatus(String dsId, String ifaceId, boolean active) throws Exception {
        this.dsManager.setActive(dsId, ifaceId, active);
    }

    public String getMetaWfId() {
        return this.metaWfId;
    }

    public void setMetaWfId(String metaWfId) {
        this.metaWfId = metaWfId;
    }
}

