/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.workflows.util;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Required;

public class WorkflowsConstants {
    public static final String SYSTEM_WF_NAME = "system:wfName";
    public static final String SYSTEM_WF_PROFILE_ID = "system:profileId";
    public static final String SYSTEM_WF_PROFILE_NAME = "system:profileName";
    public static final String SYSTEM_WF_PROFILE_FAMILY = "system:profileFamily";
    public static final String SYSTEM_WF_PRIORITY = "system:priority";
    public static final String SYSTEM_WF_PROCESS_ID = "system:processId";
    public static final String SYSTEM_ERROR = "system:error";
    public static final String SYSTEM_HAS_FAILED = "system:hasFailed";
    public static final String SYSTEM_START_HUMAN_DATE = "system:startHumanDate";
    public static final String SYSTEM_START_DATE = "system:startDate";
    public static final String SYSTEM_END_HUMAN_DATE = "system:endHumanDate";
    public static final String SYSTEM_END_DATE = "system:endDate";
    public static final String SYSTEM_COMPLETED_SUCCESSFULLY = "system:isCompletedSuccessfully";
    public static final String BLACKBOARD_IS_BLACKBOARD = "blackboard:isBlackboard";
    public static final String BLACKBOARD_JOB = "blackboard:job";
    public static final String BLACKBOARD_SERVICE_ID = "blackboard:serviceId";
    public static final String BLACKBOARD_IS_GOING = "blackboard:isOngoing";
    public static final String BLACKBOARD_PARAM_PREFIX = "blackboard:param:";
    public static final String DATAPROVIDER_PREFIX = "dataprovider:";
    public static final String DATAPROVIDER_ID = "dataprovider:id";
    public static final String DATAPROVIDER_NAME = "dataprovider:name";
    public static final String DATAPROVIDER_ACRONYM = "dataprovider:acronym";
    public static final String DATAPROVIDER_URL = "dataprovider:url";
    public static final String DATAPROVIDER_INTERFACE = "dataprovider:interface";
    public static final String DATAPROVIDER_INTERFACE_COMPLIANCE = "dataprovider:interface:compliance";
    public static final String DATAPROVIDER_INTERFACE_BASEURL = "dataprovider:interface:baseUrl";
    public static final String DATAPROVIDER_ORIGINALID = "dataprovider:originalid";
    public static final String DATAPROVIDER_NAMESPACE_PREFIX = "dataprovider:nsPrefix";
    public static final int MIN_WF_PRIORITY = 0;
    public static final int MAX_WF_PRIORITY = 100;
    public static final int DEFAULT_WF_PRIORITY = 50;
    public static final int MAX_PENDING_PROCS_SIZE = 100;
    public static final int MAX_WF_THREADS = 10;
    public static final String MAIN_LOG_PREFIX = "mainlog:";
    private String dataproviderProtocolsJson;
    private String dataproviderTypologiesJson;
    private List<Map<String, String>> dataproviderProtocols;
    private List<Map<String, String>> dataproviderTypologies;
    private List<Map<String, String>> dataproviderWorkflowStatuses;

    public void init() {
        Gson gson = new Gson();
        this.dataproviderProtocols = (List)gson.fromJson(this.dataproviderProtocolsJson, List.class);
        this.dataproviderTypologies = (List)gson.fromJson(this.dataproviderTypologiesJson, List.class);
        this.dataproviderWorkflowStatuses = Lists.newArrayList();
        for (WorkflowStatus s : WorkflowStatus.values()) {
            HashMap map = Maps.newHashMap();
            map.put("name", s.displayName);
            map.put("icon", s.icon);
            map.put("value", s.toString());
            this.dataproviderWorkflowStatuses.add(map);
        }
    }

    public String getDataproviderProtocolsJson() {
        return this.dataproviderProtocolsJson;
    }

    @Required
    public void setDataproviderProtocolsJson(String dataproviderProtocolsJson) {
        this.dataproviderProtocolsJson = dataproviderProtocolsJson;
    }

    public String getDataproviderTypologiesJson() {
        return this.dataproviderTypologiesJson;
    }

    @Required
    public void setDataproviderTypologiesJson(String dataproviderTypologiesJson) {
        this.dataproviderTypologiesJson = dataproviderTypologiesJson;
    }

    public List<Map<String, String>> getDataproviderProtocols() {
        return this.dataproviderProtocols;
    }

    public List<Map<String, String>> getDataproviderTypologies() {
        return this.dataproviderTypologies;
    }

    public List<Map<String, String>> getDataproviderWorkflowStatuses() {
        return this.dataproviderWorkflowStatuses;
    }

    public static enum WorkflowStatus {
        EXECUTABLE("Executable", "icon-ok"),
        WAIT_USER_SETTINGS("Waiting user settings", "icon-edit"),
        WAIT_SYS_SETTINGS("Waiting system settings", "icon-refresh"),
        ASSIGNED("Assigned", "icon-ok-circle"),
        MISSING("Missing workflow", "icon-warning-sign");

        public String displayName;
        public String icon;

        private WorkflowStatus(String displayName, String icon) {
            this.displayName = displayName;
            this.icon = icon;
        }
    }
}

