/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.functionality.modular.ui.objectStore;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import eu.dnetlib.data.objectstore.modular.ModularObjectStoreDeliver;
import eu.dnetlib.data.objectstore.modular.ModularObjectStoreService;
import eu.dnetlib.data.objectstore.modular.connector.ObjectStore;
import eu.dnetlib.data.objectstore.rmi.ObjectStoreFile;
import eu.dnetlib.data.objectstore.rmi.ObjectStoreServiceException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.enabling.resultset.ResultSetListener;
import eu.dnetlib.functionality.modular.ui.objectStore.info.ObjectStoreInfo;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class ObjectStoreServiceInternalController {
    private static final Log log = LogFactory.getLog(ObjectStoreServiceInternalController.class);
    @Autowired
    public UniqueServiceLocator serviceLocator;
    @Autowired
    public ModularObjectStoreService objectStoreservice;
    private final Gson gson = new Gson();
    private final Function<String, ObjectStoreFile> convertFunction = new Function<String, ObjectStoreFile>(){

        public ObjectStoreFile apply(String input) {
            return (ObjectStoreFile)ObjectStoreServiceInternalController.this.gson.fromJson(input, ObjectStoreFile.class);
        }
    };

    @RequestMapping(value={"/ui/objectStore/listObjectStores.do"})
    @ResponseBody
    public List<ObjectStoreInfo> listObjectStoreInfo(ModelMap map) throws ObjectStoreServiceException {
        HashMap inputObjectStore = Maps.newHashMap();
        this.retrieveObjectStoreFromProfiles(inputObjectStore);
        this.retrieveObjectStoreFromService(inputObjectStore);
        return Lists.newArrayList(inputObjectStore.values());
    }

    private void retrieveObjectStoreFromService(Map<String, ObjectStoreInfo> inputMap) {
        List stores = this.objectStoreservice.getFeeder().getDao().listObjectStores();
        for (String s : stores) {
            if (!inputMap.containsKey(s)) {
                try {
                    ObjectStoreInfo info = new ObjectStoreInfo();
                    ObjectStore store = this.objectStoreservice.getObjectStoreDeliver().getDao().getObjectStore(s);
                    info.setInterpretation(store.getInterpretation());
                    info.setSize(store.getSize());
                    info.setObjectStoreId(s);
                    info.setMissingObjectStore(false);
                    inputMap.put(s, info);
                }
                catch (ObjectStoreServiceException e) {
                    log.error((Object)e);
                }
                continue;
            }
            inputMap.get(s).setMissingObjectStore(false);
        }
    }

    private void retrieveObjectStoreFromProfiles(Map<String, ObjectStoreInfo> inputMap) {
        String query = "for $x in  collection('/db/DRIVER/ObjectStoreDSResources/ObjectStoreDSResourceType') \nlet $interpretation :=$x//OBJECTSTORE_INTERPRETATION\nlet $uri := $x//RESOURCE_URI/@value/string()  \nlet $id := $x//RESOURCE_IDENTIFIER/@value/string() \nlet $lastDate := $x//LAST_STORAGE_DATE  \nlet $size :=$x//STORE_SIZE \nreturn concat($uri,'@::@',$id,'@::@',$interpretation,'@::@',$lastDate,'@::@',$size) ";
        ISLookUpService lookUpService = (ISLookUpService)this.serviceLocator.getService(ISLookUpService.class);
        try {
            List results = lookUpService.quickSearchProfile("for $x in  collection('/db/DRIVER/ObjectStoreDSResources/ObjectStoreDSResourceType') \nlet $interpretation :=$x//OBJECTSTORE_INTERPRETATION\nlet $uri := $x//RESOURCE_URI/@value/string()  \nlet $id := $x//RESOURCE_IDENTIFIER/@value/string() \nlet $lastDate := $x//LAST_STORAGE_DATE  \nlet $size :=$x//STORE_SIZE \nreturn concat($uri,'@::@',$id,'@::@',$interpretation,'@::@',$lastDate,'@::@',$size) ");
            if (results == null) {
                return;
            }
            for (String result : results) {
                String[] dataInfo = result.split("@::@");
                if (dataInfo == null || dataInfo.length != 5) continue;
                String webUri = dataInfo[0];
                String id = dataInfo[1];
                String interpretation = dataInfo[2];
                String lastDate = dataInfo[3];
                int size = Integer.parseInt(dataInfo[4]);
                ObjectStoreInfo currentInfo = new ObjectStoreInfo();
                currentInfo.setObjectStoreId(id);
                currentInfo.setInterpretation(interpretation);
                currentInfo.setLastStorageDate(lastDate);
                currentInfo.setSize(size);
                currentInfo.setServiceURI(webUri);
                currentInfo.setMissingProfile(false);
                inputMap.put(id, currentInfo);
            }
        }
        catch (ISLookUpException e) {
            log.error((Object)String.format("%s", new Object[]{"Error on making query on is for $x in  collection('/db/DRIVER/ObjectStoreDSResources/ObjectStoreDSResourceType') \nlet $interpretation :=$x//OBJECTSTORE_INTERPRETATION\nlet $uri := $x//RESOURCE_URI/@value/string()  \nlet $id := $x//RESOURCE_IDENTIFIER/@value/string() \nlet $lastDate := $x//LAST_STORAGE_DATE  \nlet $size :=$x//STORE_SIZE \nreturn concat($uri,'@::@',$id,'@::@',$interpretation,'@::@',$lastDate,'@::@',$size) ", e}));
        }
    }

    @RequestMapping(value={"/ui/objectStore/getObjectStoreInfo.do"})
    @ResponseBody
    public ObjectStoreInfo getObjectStoreInfo(ModelMap map, @RequestParam(value="objId", required=true) String objId, @RequestParam(value="from", required=true) int from, @RequestParam(value="id", required=false) String recordId) {
        try {
            ModularObjectStoreDeliver objectStoreDeliver = this.objectStoreservice.getObjectStoreDeliver();
            ObjectStore store = objectStoreDeliver.getDao().getObjectStore(objId);
            ResultSetListener rs = recordId != null && !StringUtils.isEmpty((String)recordId) ? store.deliverIds((Iterable)Lists.newArrayList((Object[])new String[]{recordId})) : store.deliver(Long.valueOf(0L), Long.valueOf(System.currentTimeMillis()));
            List page = rs.getResult(1 + from, from + 25);
            ObjectStoreInfo info = new ObjectStoreInfo();
            info.setInterpretation(store.getInterpretation());
            info.setObjectStoreId(store.getId());
            info.setSize(store.getSize());
            info.setMissingObjectStore(false);
            info.setMissingProfile(this.existId(objId));
            info.setResults(Lists.transform((List)page, this.convertFunction));
            return info;
        }
        catch (ObjectStoreServiceException e) {
            return null;
        }
    }

    private boolean existId(String objectStoreId) {
        ISLookUpService lookUpService = (ISLookUpService)this.serviceLocator.getService(ISLookUpService.class);
        try {
            String resourceProfile = lookUpService.getResourceProfile(objectStoreId);
            return resourceProfile == null;
        }
        catch (ISLookUpException e) {
            log.debug((Object)(objectStoreId + " not found!"));
            return true;
        }
    }
}

