var module = angular.module('blacklist', ['ngRoute', 'blacklistControllers']);

module.config([
    '$routeProvider',
    function ($routeProvider) {
        $routeProvider
            .when('/blacklist', {
                templateUrl: '../resources/html/blacklist/blacklist.html',
                controller: 'blacklistCtrl'
            })
            .otherwise({redirectTo: '/blacklist'});
    }
]);

module.directive('ngBlacklistForm', function ($http) {
    return {
        restrict    : 'E',
        templateUrl : '../resources/html/blacklist/blacklistEntryForm.html',
        transclude  : true,
        replace     : true,
        scope: {
        	entry           : "=",
        	visible         : "=",
        	mode            : "=",
        	addFunction     : "&",
        	updateFunction  : "&"        	
        },
        link: function (scope, element, attrs, ctrl) {
            scope.entityTypes = ['result', 'project', 'datasource', 'organization', 'person'];
		    scope.relationTypes = [];

		    $(element).modal({'show': false});
            
		    scope.$watch(function() {
		    	return scope.visible;
		    }, function(value) {
		    	if (value != true) { return }
		    	$(element).modal('show');
		    	scope.visible = false;
            });
		    
		    scope.resetIisInfo = function() {
		    	delete scope.entry['iisModule'];
		    	delete scope.entry['iisStatus'];
		    }
		    
		    scope.getListOfRelationships = function () {
			    $http.get('blacklist/getListOfRelationships.do').success(function (data) {
				    scope.relationTypes = data;
			    }).error(function () {
			    	show_notification('error', 'Problems getting the list of relationships..');
			    });
		    };

		    scope.saveEntry = function() {
		    	if      (scope.mode == 'ADD')    { scope.addFunction() }
		    	else if (scope.mode == 'UPDATE') { scope.updateFunction() }
		    	else                             { show_notification('error', 'Missing Mode (ADD / UPDATE)'); }
		    }
		    
		    scope.getListOfRelationships();
        }
    }
});

module.directive('bsHasError', function () {
	return {
		restrict: "A",
		link: function (scope, element, attrs, ctrl) {
			element.toggleClass('has-feedback', true);
			var input = element.find('input[ng-model], select[ng-model], textarea[ng-model]');
			if (input) {
				scope.$watch(function () {
					if (input.controller('ngModel').$invalid) {
						return 0;
					} else if (!input.controller('ngModel').$viewValue) {
						return 1;
					} else {
						return 2;
					}
				}, function (code) {
					if (code < 0) return;
					
					if (code == 2) { input.css('color', "#666666"); }
					else           { input.css('color', "#999999"); }
					
					input.find('option').css('color', '#666666');
					input.find('option.empty').css('color', '#999999');
					
					element.toggleClass('has-error', (code == 0));
					element.toggleClass('has-warning', (code == 1));
					element.toggleClass('has-success', (code == 2));

					var feedback = element.find('.form-control-feedback');
					if (feedback) {
						feedback.toggleClass('glyphicon-remove', (code == 0));
						feedback.toggleClass('glyphicon-warning-sign', (code == 1));
						feedback.toggleClass('glyphicon-ok', (code == 2));
					}
				});
			}
		}
	};
});
