package eu.dnetlib.msro.workflows.blacklist;

import com.google.common.base.Objects;
import com.google.gson.Gson;

/**
 * Created by alessia on 26/10/15.
 */
public class ResolvedBlacklistEntry {

    private String source;

    private String target;

    private String relType;

    public ResolvedBlacklistEntry() {
    }

	public ResolvedBlacklistEntry(final String source, final String target, final String relType) {
		this.source = source;
		this.target = target;
		this.relType = relType;
	}

    public static ResolvedBlacklistEntry fromJson(String json) {
        return new Gson().fromJson(json, ResolvedBlacklistEntry.class);
    }

    @Override
    public String toString() {
        return new Gson().toJson(this);
    }

    public String getSource() {
        return source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public String getTarget() {
        return target;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public String getRelType() {
        return relType;
    }

    public void setRelType(String relType) {
        this.relType = relType;
    }

	@Override
	public boolean equals(Object another) {
		if (!(another instanceof ResolvedBlacklistEntry)) return false;
		final ResolvedBlacklistEntry rbe = (ResolvedBlacklistEntry) another;
		return Objects.equal(getSource(), rbe.getSource()) && Objects.equal(getTarget(), rbe.getTarget()) && Objects.equal(getRelType(), rbe.getRelType());
	}

	@Override
	public int hashCode() {
		return Objects.hashCode(getSource(), getTarget(), getRelType());
	}

}
