package eu.dnetlib.broker.objects;

import com.google.gson.GsonBuilder;

/**
 * Created by claudio on 11/07/16.
 */
public class OpenAireEventPayload {

	private Publication publication;

	private Publication highlight;

	private Provenance provenance;

	private float trust;

	public OpenAireEventPayload() {}

	public Publication getPublication() {
		return this.publication;
	}

	public OpenAireEventPayload setPublication(final Publication publication) {
		this.publication = publication;
		return this;
	}

	public OpenAireEventPayload setHighlight(final Publication highlight) {
		this.highlight = highlight;
		return this;
	}

	public Publication getHighlight() {
		return this.highlight;
	}

	public Provenance getProvenance() {
		return this.provenance;
	}

	public OpenAireEventPayload setProvenance(final Provenance provenance) {
		this.provenance = provenance;
		return this;
	}

	public static OpenAireEventPayload fromJSON(final String json) {
		final GsonBuilder b = new GsonBuilder();
		return b.create().fromJson(json, OpenAireEventPayload.class);
	}

	public String toJSON() {
		final GsonBuilder b = new GsonBuilder();
		return b.create().toJson(this);
	}

	public float getTrust() {
		return trust;
	}

	public OpenAireEventPayload setTrust(final float trust) {
		this.trust = trust;
		return this;
	}
}
