package eu.dnetlib.broker.objects;

import com.google.common.base.Objects;

/**
 * Created by claudio on 22/07/16.
 */
public class Instance {

	private String url;

	private String license;

	private String hostedby;

	private String instancetype;

	public Instance() {}

	public String getUrl() {
		return this.url;
	}

	public Instance setUrl(final String url) {
		this.url = url;
		return this;
	}

	public String getLicense() {
		return this.license;
	}

	public Instance setLicense(final String license) {
		this.license = license;
		return this;
	}

	public String getHostedby() {
		return this.hostedby;
	}

	public Instance setHostedby(final String hostedby) {
		this.hostedby = hostedby;
		return this;
	}

	public String getInstancetype() {
		return this.instancetype;
	}

	public Instance setInstancetype(final String instancetype) {
		this.instancetype = instancetype;
		return this;
	}

	@Override
	public int hashCode() {
		return Objects.hashCode(getUrl(), getLicense(), getHostedby(), getInstancetype());
	}

	@Override
	public boolean equals(final Object obj) {
		if (!(obj instanceof Instance)) return false;
		final Instance that = (Instance) obj;
		return Objects.equal(getUrl(), that.getUrl()) &&
				Objects.equal(getLicense(), that.getLicense()) &&
				Objects.equal(getHostedby(), that.getHostedby()) &&
				Objects.equal(getInstancetype(), that.getInstancetype());
	}
}
