/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.enabling.datasources;

import com.google.common.collect.ImmutableMap;
import eu.dnetlib.enabling.datasources.DatasourceFunctions;
import eu.dnetlib.enabling.datasources.DatasourceManagerClients;
import eu.dnetlib.enabling.datasources.DbBrowsableField;
import eu.dnetlib.enabling.datasources.LocalOpenaireDatasourceManager;
import eu.dnetlib.enabling.datasources.common.Api;
import eu.dnetlib.enabling.datasources.common.ApiParam;
import eu.dnetlib.enabling.datasources.common.BrowsableField;
import eu.dnetlib.enabling.datasources.common.BrowseTerm;
import eu.dnetlib.enabling.datasources.common.BrowseTermImpl;
import eu.dnetlib.enabling.datasources.common.Datasource;
import eu.dnetlib.enabling.datasources.common.DsmException;
import eu.dnetlib.enabling.datasources.common.DsmRuntimeException;
import eu.dnetlib.enabling.datasources.common.Identity;
import eu.dnetlib.enabling.datasources.common.Organization;
import eu.dnetlib.enabling.datasources.common.SearchApisEntry;
import eu.dnetlib.enabling.datasources.common.SimpleDatasource;
import java.io.InputStream;
import java.io.StringWriter;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.transaction.annotation.Transactional;

public class LocalOpenaireDatasourceManagerImpl
implements LocalOpenaireDatasourceManager {
    private DatasourceManagerClients datasourceManagerClients;
    private List<DbBrowsableField> browsableFields;
    public static final String QUERY_BASEDIR = "/eu/dnetlib/enabling/datasources/queries/";
    private static final Resource searchDsByType = new ClassPathResource("/eu/dnetlib/enabling/datasources/queries/searchDsByType.sql");
    private static final Resource searchApis = new ClassPathResource("/eu/dnetlib/enabling/datasources/queries/searchApisNormal.sql");
    private static final Resource searchApisUsingField = new ClassPathResource("/eu/dnetlib/enabling/datasources/queries/searchApisUsingField.sql");
    private static final Resource addDs = new ClassPathResource("/eu/dnetlib/enabling/datasources/queries/addDatasource.sql");
    private static final Resource addOrg = new ClassPathResource("/eu/dnetlib/enabling/datasources/queries/addOrganization.sql");
    private static final Resource deleteDs = new ClassPathResource("/eu/dnetlib/enabling/datasources/queries/deleteDatasource.sql");
    private static final Resource setActive = new ClassPathResource("/eu/dnetlib/enabling/datasources/queries/setActive.sql");
    private static final Resource setManaged = new ClassPathResource("/eu/dnetlib/enabling/datasources/queries/setManaged.sql");
    private static final Resource setCompliance = new ClassPathResource("/eu/dnetlib/enabling/datasources/queries/setCompliance.sql");
    private static final Resource overrideCompliance = new ClassPathResource("/eu/dnetlib/enabling/datasources/queries/overrideCompliance.sql");
    private static final Resource resetCompliance = new ClassPathResource("/eu/dnetlib/enabling/datasources/queries/resetCompliance.sql");
    private static final Resource setLastCollectionInfo = new ClassPathResource("/eu/dnetlib/enabling/datasources/queries/setLastCollectionInfo.sql");
    private static final Resource setLastAggregationInfo = new ClassPathResource("/eu/dnetlib/enabling/datasources/queries/setLastAggregationInfo.sql");
    private static final Resource setLastDownloadInfo = new ClassPathResource("/eu/dnetlib/enabling/datasources/queries/setLastDownloadInfo.sql");
    private static final Resource resetLastOperationsInfo = new ClassPathResource("/eu/dnetlib/enabling/datasources/queries/resetLastOperationsInfo.sql");
    private static final Resource insertApiParam = new ClassPathResource("/eu/dnetlib/enabling/datasources/queries/insertApiParam.sql");
    private static final Resource insertApi = new ClassPathResource("/eu/dnetlib/enabling/datasources/queries/insertApi.sql");
    private static final Log log = LogFactory.getLog(LocalOpenaireDatasourceManagerImpl.class);
    private static final String REPO_PROFILEID_SUFFIX = "_UmVwb3NpdG9yeVNlcnZpY2VSZXNvdXJjZXMvUmVwb3NpdG9yeVNlcnZpY2VSZXNvdXJjZVR5cGU=";

    @Transactional(readOnly=true)
    public Set<String> listManagedDatasourceIds() throws DsmRuntimeException {
        try {
            return this.datasourceManagerClients.searchSQL("SELECT id FROM dsm_datasources WHERE managed = true", new HashMap<String, Object>()).stream().map(m -> (String)m.get("id")).collect(Collectors.toCollection(HashSet::new));
        }
        catch (DsmException e) {
            throw new DsmRuntimeException((Throwable)e);
        }
    }

    @Transactional(readOnly=true)
    public List<SimpleDatasource> searchDatasourcesByType(String type) throws DsmException {
        return this.datasourceManagerClients.searchSQL(searchDsByType, (Map<String, Object>)ImmutableMap.of((Object)"type", (Object)type)).stream().map(DatasourceFunctions::mapToSimpleDs).collect(Collectors.toList());
    }

    @Transactional(readOnly=true)
    public List<? extends SearchApisEntry> searchApis(String field, Object value) throws DsmException {
        try {
            StringWriter sql = new StringWriter();
            if (field.equalsIgnoreCase("__search__")) {
                sql.append(IOUtils.toString((InputStream)searchApis.getInputStream()));
            } else {
                sql.append(IOUtils.toString((InputStream)searchApisUsingField.getInputStream()));
                sql.append(field);
                sql.append("::text = ");
                sql.append(":value");
            }
            return this.datasourceManagerClients.searchSQL(sql.toString(), (Map<String, Object>)ImmutableMap.of((Object)"value", (Object)(field.equalsIgnoreCase("__search__") ? "%" + value + "%" : value))).stream().map(DatasourceFunctions::mapToSearchApisEntry).collect(Collectors.toList());
        }
        catch (Exception e) {
            log.error((Object)("Error searching field " + field + " - value: " + value), (Throwable)e);
            return new ArrayList();
        }
    }

    @Transactional
    public void saveDs(Datasource<Organization<?>, Identity> ds) throws DsmException {
        if (StringUtils.isBlank((String)ds.getAggregator())) {
            ds.setAggregator("OPENAIRE");
        }
        ds.setManaged(Boolean.valueOf(true));
        this.datasourceManagerClients.updateSQL(ds.getId(), addDs, DatasourceManagerClients.AfterSqlUpdate.NONE, DatasourceFunctions.dsToMap(ds));
        if (ds.getOrganizations() != null) {
            for (Organization org : ds.getOrganizations()) {
                Map<String, Object> orgParams = DatasourceFunctions.orgToMap(ds.getId(), org);
                this.datasourceManagerClients.updateSQL(ds.getId(), addOrg, DatasourceManagerClients.AfterSqlUpdate.NONE, orgParams);
            }
        }
        this.datasourceManagerClients.regenerateProfile(ds.getId());
    }

    @Transactional
    public void deleteDs(String dsId) throws DsmException {
        this.datasourceManagerClients.updateSQL(this.fixDsId(dsId), deleteDs, DatasourceManagerClients.AfterSqlUpdate.DELETE_DS_PROFILE, (Map<String, Object>)ImmutableMap.of((Object)"dsId", (Object)dsId));
    }

    public Datasource<Organization<?>, Identity> getDs(String dsId) throws DsmException {
        return this.datasourceManagerClients.getDatasourceById(this.fixDsId(dsId));
    }

    public void regenerateProfiles() throws DsmException {
        this.datasourceManagerClients.regenerateProfiles();
    }

    public List<Api<ApiParam>> getApis(String dsId) throws DsmException {
        return this.datasourceManagerClients.getApis(this.fixDsId(dsId));
    }

    public void setManaged(String dsId, boolean managed) throws DsmException {
        String id = this.fixDsId(dsId);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("managed", managed);
        params.put("dsId", id);
        this.datasourceManagerClients.updateSQL(id, setManaged, DatasourceManagerClients.AfterSqlUpdate.UPDATE_DS_PROFILE, params);
    }

    public boolean isManaged(String dsId) throws DsmException {
        String q = "SELECT * from dsm_datasources WHERE id = :dsId AND managed = true";
        return !this.datasourceManagerClients.searchSQL("SELECT * from dsm_datasources WHERE id = :dsId AND managed = true", (Map<String, Object>)ImmutableMap.of((Object)"dsId", (Object)this.fixDsId(dsId))).isEmpty();
    }

    @Transactional
    public void setActive(String dsId, String apiId, boolean active) throws DsmException {
        String id = this.fixDsId(dsId);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("active", active);
        params.put("apiId", apiId);
        params.put("dsId", id);
        this.datasourceManagerClients.updateSQL(id, setActive, DatasourceManagerClients.AfterSqlUpdate.NONE, params);
        if (!active) {
            this.datasourceManagerClients.updateSQL(dsId, resetLastOperationsInfo, DatasourceManagerClients.AfterSqlUpdate.NONE, params);
        }
        this.setManaged(id, true);
    }

    @Transactional(readOnly=true)
    public boolean isActive(String dsId, String apiId) throws DsmException {
        String q = "SELECT * from dsm_api WHERE id = :apiId AND datasource = :dsId AND active = true";
        return !this.datasourceManagerClients.searchSQL("SELECT * from dsm_api WHERE id = :apiId AND datasource = :dsId AND active = true", (Map<String, Object>)ImmutableMap.of((Object)"dsId", (Object)this.fixDsId(dsId), (Object)"apiId", (Object)apiId)).isEmpty();
    }

    @Transactional(readOnly=true)
    public boolean isRemovable(String dsId, String apiId) throws DsmException {
        String q = "SELECT * from dsm_api WHERE id = :apiId AND datasource = :dsId AND active != true AND removable = true";
        return !this.datasourceManagerClients.searchSQL("SELECT * from dsm_api WHERE id = :apiId AND datasource = :dsId AND active != true AND removable = true", (Map<String, Object>)ImmutableMap.of((Object)"dsId", (Object)this.fixDsId(dsId), (Object)"apiId", (Object)apiId)).isEmpty();
    }

    @Transactional
    public void updateCompliance(String dsId, String apiId, String level, boolean override) throws DsmException {
        String id = this.fixDsId(dsId);
        if (!override) {
            this.datasourceManagerClients.updateSQL(id, setCompliance, DatasourceManagerClients.AfterSqlUpdate.NONE, (Map<String, Object>)ImmutableMap.of((Object)"level", (Object)level, (Object)"apiId", (Object)apiId, (Object)"dsId", (Object)id));
        } else if (level != null) {
            this.datasourceManagerClients.updateSQL(id, overrideCompliance, DatasourceManagerClients.AfterSqlUpdate.NONE, (Map<String, Object>)ImmutableMap.of((Object)"level", (Object)level, (Object)"apiId", (Object)apiId, (Object)"dsId", (Object)id));
        } else {
            this.datasourceManagerClients.updateSQL(id, resetCompliance, DatasourceManagerClients.AfterSqlUpdate.NONE, (Map<String, Object>)ImmutableMap.of((Object)"apiId", (Object)apiId, (Object)"dsId", (Object)id));
        }
        this.setManaged(id, true);
    }

    public void setLastCollectionInfo(String dsId, String apiId, String mdId, Integer size, Date date) throws DsmException {
        this.setLastOperationInfo(setLastCollectionInfo, this.fixDsId(dsId), apiId, mdId, size, date);
    }

    public void setLastAggregationInfo(String dsId, String apiId, String mdId, Integer size, Date date) throws DsmException {
        this.setLastOperationInfo(setLastAggregationInfo, this.fixDsId(dsId), apiId, mdId, size, date);
    }

    public void setLastDownloadInfo(String dsId, String apiId, String objId, Integer size, Date date) throws DsmException {
        this.setLastOperationInfo(setLastDownloadInfo, this.fixDsId(dsId), apiId, objId, size, date);
    }

    @Transactional
    protected void setLastOperationInfo(Resource sqlResource, String dsId, String apiId, String mdId, Integer size, Date date) throws DsmException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("dsId", dsId);
        params.put("apiId", apiId);
        params.put("mdId", mdId);
        params.put("total", size);
        if (date != null) {
            params.put("date", new Timestamp(date.getTime()));
        }
        this.datasourceManagerClients.updateSQL(dsId, sqlResource, DatasourceManagerClients.AfterSqlUpdate.NONE, params);
        this.setManaged(dsId, true);
    }

    @Transactional
    public void updateApiDetails(String dsId, String apiId, String metadataIdentifierPath, String baseUrl, Map<String, String> params) throws DsmException {
        String id = this.fixDsId(dsId);
        this.datasourceManagerClients.updateSQL(id, "DELETE FROM dsm_apiparams WHERE api = :api", DatasourceManagerClients.AfterSqlUpdate.NONE, (Map<String, Object>)ImmutableMap.of((Object)"api", (Object)apiId));
        for (Map.Entry<String, String> e : params.entrySet()) {
            ImmutableMap sqlParams = ImmutableMap.of((Object)"param", (Object)e.getKey(), (Object)"value", (Object)e.getValue(), (Object)"api", (Object)apiId);
            this.datasourceManagerClients.updateSQL(id, insertApiParam, DatasourceManagerClients.AfterSqlUpdate.NONE, (Map<String, Object>)sqlParams);
        }
        this.datasourceManagerClients.updateSQL(id, "UPDATE dsm_api SET baseurl = :baseurl WHERE id = :api", DatasourceManagerClients.AfterSqlUpdate.NONE, (Map<String, Object>)ImmutableMap.of((Object)"baseurl", (Object)baseUrl, (Object)"api", (Object)apiId));
        this.datasourceManagerClients.updateSQL(id, "UPDATE dsm_api SET metadata_identifier_path = :path WHERE id = :api", DatasourceManagerClients.AfterSqlUpdate.NONE, (Map<String, Object>)ImmutableMap.of((Object)"path", (Object)metadataIdentifierPath, (Object)"api", (Object)apiId));
        this.setManaged(id, true);
    }

    public List<? extends BrowsableField> listBrowsableFields() throws DsmException {
        return this.getBrowsableFields();
    }

    public List<BrowseTerm> browseField(String field) throws DsmException {
        Optional<DbBrowsableField> bf = this.getBrowsableFields().stream().filter(f -> f.getId().equals(field)).findFirst();
        if (bf.isPresent()) {
            return this.datasourceManagerClients.searchSQL(bf.get().getSql(), new HashMap<String, Object>()).stream().filter(m -> m.get("term") != null).filter(m -> m.get("count") != null).filter(m -> StringUtils.isNotBlank((String)m.get("term").toString())).map(m -> new BrowseTermImpl(m.get("term").toString(), NumberUtils.toInt((String)m.get("count").toString(), (int)0))).collect(Collectors.toList());
        }
        log.error((Object)("Not browsable field:" + field));
        throw new DsmException("Not browsable field:" + field);
    }

    @Transactional
    public void addApi(Api<ApiParam> api) throws DsmException {
        this.datasourceManagerClients.updateSQL(api.getDatasource(), insertApi, DatasourceManagerClients.AfterSqlUpdate.NONE, DatasourceFunctions.apiToMap(api));
        api.getApiParams().forEach(p -> {
            ImmutableMap sqlParams = ImmutableMap.of((Object)"param", (Object)p.getParam(), (Object)"value", (Object)p.getValue(), (Object)"api", (Object)api.getId());
            try {
                this.datasourceManagerClients.updateSQL(api.getDatasource(), insertApiParam, DatasourceManagerClients.AfterSqlUpdate.NONE, (Map<String, Object>)sqlParams);
            }
            catch (DsmException e) {
                throw new RuntimeException(e);
            }
        });
        this.setManaged(api.getDatasource(), true);
    }

    @Transactional
    public void deleteApi(String dsId, String apiId) throws DsmException {
        if (!this.isRemovable(dsId, apiId)) {
            throw new DsmException("The api " + apiId + " can't be deleted");
        }
        this.datasourceManagerClients.updateSQL(dsId, "DELETE FROM dsm_apiparams WHERE api = :api", DatasourceManagerClients.AfterSqlUpdate.NONE, (Map<String, Object>)ImmutableMap.of((Object)"api", (Object)apiId));
        this.datasourceManagerClients.updateSQL(dsId, "DELETE FROM dsm_api WHERE id = :api", DatasourceManagerClients.AfterSqlUpdate.NONE, (Map<String, Object>)ImmutableMap.of((Object)"api", (Object)apiId));
        this.setManaged(dsId, true);
    }

    public DatasourceManagerClients getDatasourceManagerClients() {
        return this.datasourceManagerClients;
    }

    private String fixDsId(String dsId) throws DsmException {
        return dsId.endsWith(REPO_PROFILEID_SUFFIX) ? this.datasourceManagerClients.findDatasourceId(dsId) : dsId;
    }

    @Required
    public void setDatasourceManagerClients(DatasourceManagerClients datasourceManagerClients) {
        this.datasourceManagerClients = datasourceManagerClients;
    }

    public List<DbBrowsableField> getBrowsableFields() {
        return this.browsableFields;
    }

    @Required
    public void setBrowsableFields(List<DbBrowsableField> browsableFields) {
        this.browsableFields = browsableFields;
    }
}

