SELECT 
	a.id                                                                     AS "id",
	a.protocol                                                               AS "protocol",
	coalesce(a.compatibility_override, a.compatibility)                      AS "compliance",
	a.active                                                                 AS "active",
	a.baseurl                                                                AS "baseUrl",
	coalesce(a.last_aggregation_date::text, a.last_download_date::text, '')  AS "aggrDate",
	coalesce(a.last_aggregation_total, a.last_download_total, 0)             AS "aggrTotal",
	ds.id                                                                    AS "dsId",
	ds.officialname                                                          AS "name",
	ds.englishname                                                           AS "alternativeName",
	ds.namespaceprefix                                                       AS "prefix",
	ds.websiteurl                                                            AS "websiteUrl",
	coalesce((array_agg(o.country))[1], '-')                                 AS "country",
    (array_agg(o.legalname))[1]                                              AS "organization"
FROM dsm_api a
	LEFT OUTER JOIN dsm_datasources ds ON (a.datasource = ds.id)
	LEFT OUTER JOIN dsm_datasource_organization dsorg ON (ds.id = dsorg.datasource)
	LEFT OUTER JOIN dsm_organizations o ON (dsorg.organization = o.id)
WHERE
	ds.id                 ILIKE :value 
	OR ds.officialname    ILIKE :value
	OR ds.englishname     ILIKE :value
	OR ds.namespaceprefix ILIKE :value
	OR ds.websiteurl      ILIKE :value
	OR a.baseurl          ILIKE :value
	OR o.legalname        ILIKE :value
GROUP BY
	a.id,
	a.protocol,
	a.compatibility_override,
	a.compatibility,
	a.active,
	a.last_aggregation_date,
	a.last_download_date,
	a.last_aggregation_total,
	a.last_download_total,
	ds.id,
	ds.officialname,
	ds.englishname,
	ds.namespaceprefix,
	ds.websiteurl


