/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.enabling.datasources;

import eu.dnetlib.enabling.datasources.common.Api;
import eu.dnetlib.enabling.datasources.common.ApiParam;
import eu.dnetlib.enabling.datasources.common.ApiParamImpl;
import eu.dnetlib.enabling.datasources.common.Datasource;
import eu.dnetlib.enabling.datasources.common.Identity;
import eu.dnetlib.enabling.datasources.common.Organization;
import eu.dnetlib.enabling.datasources.common.SearchApisEntry;
import eu.dnetlib.enabling.datasources.common.SimpleDatasource;
import eu.dnetlib.miscutils.datetime.DateUtils;
import java.io.IOException;
import java.sql.Array;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;

public class DatasourceFunctions {
    private static final Log log = LogFactory.getLog(DatasourceFunctions.class);
    private static final Resource baseDsProfile = new ClassPathResource("/eu/dnetlib/enabling/datasources/templates/datasource_base.xml");

    public static SimpleDatasource mapToSimpleDs(Map<String, Object> map) {
        SimpleDatasource ds = new SimpleDatasource();
        ds.setId(DatasourceFunctions.castObject(map.get("id"), String.class));
        ds.setName(DatasourceFunctions.castObject(map.get("name"), String.class));
        ds.setOrigId(DatasourceFunctions.castObject(map.get("id"), String.class));
        ds.setTypology(DatasourceFunctions.castObject(map.get("typology"), String.class));
        ds.setValid(true);
        try {
            Array arr = DatasourceFunctions.castObject(map.get("apis"), Array.class);
            if (arr != null && ((Object[])arr.getArray()).length > 0) {
                ds.setApis(Arrays.stream((Object[])arr.getArray()).filter(Objects::nonNull).map(Object::toString).collect(Collectors.toSet()));
            }
        }
        catch (SQLException e) {
            log.error((Object)"Error parsing array (apis)", (Throwable)e);
            throw new RuntimeException("Error parsing array (apis)", e);
        }
        return ds;
    }

    public static Datasource<Organization<?>, Identity> mapToDatasource(Map<String, Object> map) {
        Datasource ds = new Datasource();
        ds.setId(DatasourceFunctions.castObject(map.get("id"), String.class));
        ds.setOfficialname(DatasourceFunctions.castObject(map.get("officialname"), String.class));
        ds.setEnglishname(DatasourceFunctions.castObject(map.get("englishname"), String.class));
        ds.setWebsiteurl(DatasourceFunctions.castObject(map.get("websiteurl"), String.class));
        ds.setLogourl(DatasourceFunctions.castObject(map.get("logourl"), String.class));
        ds.setContactemail(DatasourceFunctions.castObject(map.get("contactemail"), String.class));
        ds.setLatitude(DatasourceFunctions.castObject(map.get("latitude"), Double.class));
        ds.setLongitude(DatasourceFunctions.castObject(map.get("longitude"), Double.class));
        ds.setTimezone(DatasourceFunctions.castObject(map.get("timezone"), String.class));
        ds.setNamespaceprefix(DatasourceFunctions.castObject(map.get("namespaceprefix"), String.class));
        ds.setLanguages(DatasourceFunctions.castObject(map.get("languages"), String.class));
        ds.setOd_contenttypes(DatasourceFunctions.castObject(map.get("od_contenttypes"), String.class));
        ds.setCollectedfrom(DatasourceFunctions.castObject(map.get("collectedfrom"), String.class));
        ds.setDateofvalidation(DatasourceFunctions.castObject(map.get("dateofvalidation"), Date.class));
        ds.setTypology(DatasourceFunctions.castObject(map.get("typology"), String.class));
        ds.setProvenanceaction(DatasourceFunctions.castObject(map.get("provenanceaction"), String.class));
        ds.setDateofcollection(DatasourceFunctions.castObject(map.get("dateofcollection"), Date.class));
        ds.setPlatform(DatasourceFunctions.castObject(map.get("platform"), String.class));
        ds.setActivationId(DatasourceFunctions.castObject(map.get("activationId"), String.class));
        ds.setDescription(DatasourceFunctions.castObject(map.get("description"), String.class));
        ds.setReleasestartdate(DatasourceFunctions.castObject(map.get("releasestartdate"), Date.class));
        ds.setReleaseenddate(DatasourceFunctions.castObject(map.get("releaseenddate"), Date.class));
        ds.setMissionstatementurl(DatasourceFunctions.castObject(map.get("missionstatementurl"), String.class));
        ds.setDataprovider(DatasourceFunctions.castObject(map.get("dataprovider"), Boolean.class));
        ds.setServiceprovider(DatasourceFunctions.castObject(map.get("serviceprovider"), Boolean.class));
        ds.setDatabaseaccesstype(DatasourceFunctions.castObject(map.get("databaseaccesstype"), String.class));
        ds.setDatauploadtype(DatasourceFunctions.castObject(map.get("datauploadtype"), String.class));
        ds.setDatabaseaccessrestriction(DatasourceFunctions.castObject(map.get("databaseaccessrestriction"), String.class));
        ds.setDatauploadrestriction(DatasourceFunctions.castObject(map.get("datauploadrestriction"), String.class));
        ds.setVersioning(DatasourceFunctions.castObject(map.get("versioning"), Boolean.class));
        ds.setCitationguidelineurl(DatasourceFunctions.castObject(map.get("citationguidelineurl"), String.class));
        ds.setQualitymanagementkind(DatasourceFunctions.castObject(map.get("qualitymanagementkind"), String.class));
        ds.setPidsystems(DatasourceFunctions.castObject(map.get("pidsystems"), String.class));
        ds.setCertificates(DatasourceFunctions.castObject(map.get("certificates"), String.class));
        ds.setAggregator(DatasourceFunctions.castObject(map.get("aggregator"), String.class));
        ds.setIssn(DatasourceFunctions.castObject(map.get("issn"), String.class));
        ds.setEissn(DatasourceFunctions.castObject(map.get("eissn"), String.class));
        ds.setLissn(DatasourceFunctions.castObject(map.get("lissn"), String.class));
        ds.setRegisteredby(DatasourceFunctions.castObject(map.get("registeredby"), String.class));
        ds.setSubjects(DatasourceFunctions.castObject(map.get("subjects"), String.class));
        ds.setManaged(DatasourceFunctions.castObject(map.get("managed"), Boolean.class));
        return ds;
    }

    public static Identity mapToDsIdentity(Map<String, Object> map) {
        Identity id = new Identity();
        id.setPid(DatasourceFunctions.castObject(map.get("pid"), String.class));
        id.setIssuertype(DatasourceFunctions.castObject(map.get("issuertype"), String.class));
        return id;
    }

    public static Organization<Datasource<?, ?>> mapToDsOrganization(Map<String, Object> map) {
        Organization org = new Organization();
        org.setId(DatasourceFunctions.castObject(map.get("id"), String.class));
        org.setLegalshortname(DatasourceFunctions.castObject(map.get("legalshortname"), String.class));
        org.setLegalname(DatasourceFunctions.castObject(map.get("legalname"), String.class));
        org.setWebsiteurl(DatasourceFunctions.castObject(map.get("websiteurl"), String.class));
        org.setLogourl(DatasourceFunctions.castObject(map.get("logourl"), String.class));
        org.setCountry(DatasourceFunctions.castObject(map.get("country"), String.class));
        org.setCollectedfrom(DatasourceFunctions.castObject(map.get("collectedfrom"), String.class));
        org.setDateofcollection(DatasourceFunctions.castObject(map.get("dateofcollection"), Date.class));
        org.setProvenanceaction(DatasourceFunctions.castObject(map.get("provenanceaction"), String.class));
        return org;
    }

    public static SearchApisEntry mapToSearchApisEntry(Map<String, Object> map) {
        SearchApisEntry a = new SearchApisEntry();
        a.setId(DatasourceFunctions.castObject(map.get("id"), String.class));
        a.setCompliance(DatasourceFunctions.castObject(map.get("compliance"), String.class));
        a.setActive(DatasourceFunctions.castObject(map.get("active"), Boolean.class).booleanValue());
        a.setRepoId(DatasourceFunctions.castObject(map.get("dsId"), String.class));
        a.setRepoName(DatasourceFunctions.castObject(map.get("name"), String.class));
        a.setRepoCountry(DatasourceFunctions.castObject(map.get("country"), String.class));
        a.setRepoPrefix(DatasourceFunctions.castObject(map.get("prefix"), String.class));
        a.setAggrDate(DatasourceFunctions.castObject(map.get("aggrDate"), String.class));
        a.setAggrTotal(DatasourceFunctions.castObject(map.get("aggrTotal"), Integer.class).intValue());
        a.setProtocol(DatasourceFunctions.castObject(map.get("protocol"), String.class));
        a.setAlternativeName(DatasourceFunctions.castObject(map.get("alternativeName"), String.class));
        a.setRepoOrganization(DatasourceFunctions.castObject(map.get("organization"), String.class));
        return a;
    }

    public static Api<ApiParam> mapToApi(Map<String, Object> map) {
        Api a = new Api();
        a.setId(DatasourceFunctions.castObject(map.get("id"), String.class));
        a.setProtocol(DatasourceFunctions.castObject(map.get("protocol"), String.class));
        a.setDatasource(DatasourceFunctions.castObject(map.get("datasource"), String.class));
        a.setContentdescription(DatasourceFunctions.castObject(map.get("contentdescription"), String.class));
        a.setActive(DatasourceFunctions.castObject(map.get("active"), Boolean.class));
        a.setRemovable(DatasourceFunctions.castObject(map.get("removable"), Boolean.class));
        a.setTypology(DatasourceFunctions.castObject(map.get("typology"), String.class));
        a.setCompatibility(DatasourceFunctions.castObject(map.get("compatibility"), String.class));
        a.setCompatibilityOverrided(DatasourceFunctions.castObject(map.get("isCompatibilityOverrided"), Boolean.class).booleanValue());
        a.setMetadataIdentifierPath(DatasourceFunctions.castObject(map.get("metadataIdentifierPath"), String.class));
        a.setLastCollectionTotal(DatasourceFunctions.castObject(map.get("lastCollectionTotal"), Integer.class));
        a.setLastCollectionDate(DatasourceFunctions.castObject(map.get("lastCollectionDate"), Timestamp.class));
        a.setLastCollectionMdid(DatasourceFunctions.castObject(map.get("lastCollectionMdid"), String.class));
        a.setLastAggregationTotal(DatasourceFunctions.castObject(map.get("lastAggregationTotal"), Integer.class));
        a.setLastAggregationDate(DatasourceFunctions.castObject(map.get("lastAggregationDate"), Timestamp.class));
        a.setLastAggregationMdid(DatasourceFunctions.castObject(map.get("lastAggregationMdid"), String.class));
        a.setLastDownloadTotal(DatasourceFunctions.castObject(map.get("lastDownloadTotal"), Integer.class));
        a.setLastDownloadDate(DatasourceFunctions.castObject(map.get("lastDownloadDate"), Timestamp.class));
        a.setLastDownloadObjid(DatasourceFunctions.castObject(map.get("lastDownloadObjid"), String.class));
        a.setLastValidationJob(DatasourceFunctions.castObject(map.get("lastValidationJob"), String.class));
        a.setBaseurl(DatasourceFunctions.castObject(map.get("baseUrl"), String.class));
        try {
            Array arr = DatasourceFunctions.castObject(map.get("params"), Array.class);
            if (arr != null) {
                a.setApiParams(Arrays.stream((Object[])arr.getArray()).filter(Objects::nonNull).map(Object::toString).map(s -> {
                    ApiParamImpl p = new ApiParamImpl();
                    p.setParam(StringUtils.substringBefore((String)s, (String)"="));
                    p.setValue(StringUtils.substringAfter((String)s, (String)"="));
                    return p;
                }).collect(Collectors.toSet()));
            }
        }
        catch (SQLException e) {
            log.error((Object)"Error parsing array params", (Throwable)e);
            throw new RuntimeException("Error parsing array params", e);
        }
        return a;
    }

    public static String dsToProfile(Datasource<Organization<?>, Identity> ds, List<Api<ApiParam>> apis, String profId) throws DocumentException, IOException {
        Document doc = new SAXReader().read(baseDsProfile.getInputStream());
        DatasourceFunctions.setValue(doc, "//DATASOURCE_TYPE", ds.getTypology());
        DatasourceFunctions.setValue(doc, "//DATASOURCE_ORIGINAL_ID", ds.getId());
        DatasourceFunctions.setValue(doc, "//TYPOLOGY", ds.getPlatform());
        DatasourceFunctions.setValue(doc, "//OFFICIAL_NAME", ds.getOfficialname());
        DatasourceFunctions.setValue(doc, "//ENGLISH_NAME", ds.getEnglishname());
        DatasourceFunctions.setValue(doc, "//ICON_URI", ds.getLogourl());
        DatasourceFunctions.setValue(doc, "//COUNTRY", ds.getOrganizations().stream().map(Organization::getCountry).findFirst().orElse(""));
        DatasourceFunctions.setValue(doc, "//LONGITUDE", ds.getLongitude());
        DatasourceFunctions.setValue(doc, "//LATITUDE", ds.getLatitude());
        DatasourceFunctions.setValue(doc, "//TIMEZONE", ds.getTimezone());
        DatasourceFunctions.setValue(doc, "//REPOSITORY_WEBPAGE", ds.getWebsiteurl());
        DatasourceFunctions.setValue(doc, "//REPOSITORY_INSTITUTION", ds.getOrganizations().stream().map(Organization::getLegalname).findFirst().orElse(""));
        DatasourceFunctions.setValue(doc, "//ADMIN_INFO", ds.getContactemail());
        DatasourceFunctions.setValue(doc, "//REGISTERED_BY", ds.getRegisteredby());
        DatasourceFunctions.setValue(doc, "//LAST_UPDATE/@value", DateUtils.now_ISO8601());
        Element ef = (Element)doc.selectSingleNode("//EXTRA_FIELDS");
        DatasourceFunctions.addExtraField(ef, "OpenAireDataSourceId", ds.getId());
        DatasourceFunctions.addExtraField(ef, "NamespacePrefix", ds.getNamespaceprefix());
        DatasourceFunctions.addExtraField(ef, "VERIFIED", "NO");
        DatasourceFunctions.addExtraField(ef, "aggregatorName", ds.getAggregator());
        DatasourceFunctions.addExtraField(ef, "dateOfValidation", ds.getDateofvalidation());
        DatasourceFunctions.addExtraField(ef, "dateOfCollection", ds.getDateofcollection());
        DatasourceFunctions.addExtraField(ef, "mergeHomonyms", "NO");
        DatasourceFunctions.addExtraField(ef, "ACTID", ds.getActivationId());
        if (apis != null) {
            Element ifaces = (Element)doc.selectSingleNode("//INTERFACES");
            apis.forEach(api -> DatasourceFunctions.addInterface(ifaces, api));
        }
        return doc.asXML();
    }

    private static void setValue(Document doc, String xpath, Object value) {
        if (value != null) {
            doc.selectSingleNode(xpath).setText(value.toString());
        }
    }

    private static void addInterface(Element ifaces, Api<?> api) {
        Element ifc = ifaces.addElement("INTERFACE");
        ifc.addAttribute("id", api.getId());
        ifc.addAttribute("label", String.format("%s (%s)", StringUtils.defaultIfBlank((CharSequence)api.getTypology(), (CharSequence)"-"), StringUtils.defaultIfBlank((CharSequence)api.getCompatibility(), (CharSequence)"-")));
        ifc.addAttribute("typology", (String)StringUtils.defaultIfBlank((CharSequence)api.getTypology(), (CharSequence)""));
        ifc.addAttribute("active", "" + BooleanUtils.toBooleanDefaultIfNull((Boolean)api.getActive(), (boolean)false));
        ifc.addAttribute("compliance", (String)StringUtils.defaultIfBlank((CharSequence)api.getCompatibility(), (CharSequence)""));
        ifc.addAttribute("contentDescription", (String)StringUtils.defaultIfBlank((CharSequence)api.getContentdescription(), (CharSequence)""));
        ifc.addAttribute("removable", "" + BooleanUtils.toBooleanDefaultIfNull((Boolean)api.getRemovable(), (boolean)false));
        Element ap = ifc.addElement("ACCESS_PROTOCOL");
        api.getApiParams().forEach(p -> ap.addAttribute(p.getParam(), p.getValue()));
        ap.setText((String)StringUtils.defaultIfBlank((CharSequence)api.getProtocol(), (CharSequence)""));
        ifc.addElement("BASE_URL").setText((String)StringUtils.defaultIfBlank((CharSequence)api.getBaseurl(), (CharSequence)""));
        if (api.isCompatibilityOverrided()) {
            DatasourceFunctions.addInterfaceExtraField(ifc, "overriding_compliance", true);
        }
        DatasourceFunctions.addInterfaceExtraField(ifc, "metadata_identifier_path", api.getMetadataIdentifierPath());
        DatasourceFunctions.addInterfaceExtraField(ifc, "last_collection_date", api.getLastCollectionDate());
        DatasourceFunctions.addInterfaceExtraField(ifc, "last_collection_mdId", api.getLastCollectionMdid());
        DatasourceFunctions.addInterfaceExtraField(ifc, "last_collection_total", api.getLastCollectionTotal());
        DatasourceFunctions.addInterfaceExtraField(ifc, "last_aggregation_date", api.getLastAggregationDate());
        DatasourceFunctions.addInterfaceExtraField(ifc, "last_aggregation_mdId", api.getLastAggregationMdid());
        DatasourceFunctions.addInterfaceExtraField(ifc, "last_aggregation_total", api.getLastAggregationTotal());
        DatasourceFunctions.addInterfaceExtraField(ifc, "last_download_date", api.getLastDownloadDate());
        DatasourceFunctions.addInterfaceExtraField(ifc, "last_download_objId", api.getLastDownloadObjid());
        DatasourceFunctions.addInterfaceExtraField(ifc, "last_download_total", api.getLastDownloadTotal());
    }

    private static void addExtraField(Element parent, String field, Object value) {
        if (value != null && StringUtils.isNotBlank((CharSequence)value.toString())) {
            Element f = parent.addElement("FIELD");
            f.addElement("key").setText(field);
            f.addElement("value").setText(value.toString());
        }
    }

    private static void addInterfaceExtraField(Element parent, String field, Object value) {
        if (value != null && StringUtils.isNotBlank((CharSequence)value.toString())) {
            Element f = parent.addElement("INTERFACE_EXTRA_FIELD");
            f.addAttribute("name", field);
            f.setText(value.toString());
        }
    }

    public static Map<String, Object> dsToMap(Datasource<Organization<?>, Identity> ds) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("id", ds.getId());
        map.put("officialname", ds.getOfficialname());
        map.put("englishname", ds.getEnglishname());
        map.put("websiteurl", ds.getWebsiteurl());
        map.put("logourl", ds.getLogourl());
        map.put("contactemail", ds.getContactemail());
        map.put("latitude", ds.getLatitude());
        map.put("longitude", ds.getLongitude());
        map.put("timezone", ds.getTimezone());
        map.put("namespaceprefix", ds.getNamespaceprefix());
        map.put("languages", ds.getLanguages());
        map.put("od_contenttypes", ds.getOd_contenttypes());
        map.put("collectedfrom", ds.getCollectedfrom());
        map.put("dateofvalidation", ds.getDateofvalidation());
        map.put("typology", ds.getTypology());
        map.put("provenanceaction", ds.getProvenanceaction());
        map.put("platform", ds.getPlatform());
        map.put("activationid", ds.getActivationId());
        map.put("description", ds.getDescription());
        map.put("releasestartdate", ds.getReleasestartdate());
        map.put("releaseenddate", ds.getReleaseenddate());
        map.put("missionstatementurl", ds.getMissionstatementurl());
        map.put("dataprovider", ds.getDataprovider());
        map.put("serviceprovider", ds.getServiceprovider());
        map.put("databaseaccesstype", ds.getDatabaseaccesstype());
        map.put("datauploadtype", ds.getDatauploadtype());
        map.put("databaseaccessrestriction", ds.getDatabaseaccessrestriction());
        map.put("datauploadrestriction", ds.getDatauploadrestriction());
        map.put("versioning", ds.getVersioning());
        map.put("citationguidelineurl", ds.getCitationguidelineurl());
        map.put("qualitymanagementkind", ds.getQualitymanagementkind());
        map.put("pidsystems", ds.getPidsystems());
        map.put("certificates", ds.getCertificates());
        map.put("aggregator", ds.getAggregator());
        map.put("issn", ds.getIssn());
        map.put("eissn", ds.getEissn());
        map.put("lissn", ds.getLissn());
        map.put("registeredby", ds.getRegisteredby());
        map.put("subjects", ds.getSubjects());
        map.put("managed", ds.getManaged());
        return map;
    }

    public static Map<String, Object> orgToMap(String dsId, Organization<?> org) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("dsId", dsId);
        map.put("orgId", org.getId());
        map.put("legalname", org.getLegalname());
        map.put("legalshortname", org.getLegalshortname());
        map.put("websiteurl", org.getWebsiteurl());
        map.put("logourl", org.getLogourl());
        map.put("country", org.getCountry());
        return map;
    }

    public static Map<String, Object> apiToMap(Api<?> api) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("apiId", api.getId());
        map.put("protocol", api.getProtocol());
        map.put("baseUrl", api.getBaseurl());
        map.put("dsId", api.getDatasource());
        map.put("contentDescription", api.getContentdescription());
        map.put("typology", api.getTypology());
        map.put("compatibility", api.getCompatibility());
        map.put("metadataIdentifierPath", api.getMetadataIdentifierPath());
        map.put("removable", api.getRemovable());
        return map;
    }

    private static <T> T castObject(Object o, Class<T> clazz) {
        if (o == null) {
            return null;
        }
        if (clazz.isInstance(o)) {
            return (T)o;
        }
        throw new IllegalArgumentException("Type not managed: " + clazz.getSimpleName());
    }
}

